/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class SoundTools {
    public static SoundEvent createSoundEvent(ResourceLocation id) {
        return SoundEvent.createVariableRangeEvent((ResourceLocation)id);
    }

    public static SoundEvent findSound(ResourceLocation name) {
        return switch (name.toString()) {
            case "minecraft:block.note_block.bell" -> (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value();
            case "minecraft:block.note_block.pling" -> (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value();
            default -> SoundEvents.EXPERIENCE_ORB_PICKUP;
        };
    }

    public static void playSound(Level worldObj, SoundEvent soundName, double x, double y, double z, double volume, double pitch) {
        ClientboundSoundPacket soundEffect = new ClientboundSoundPacket(Holder.direct((Object)soundName), SoundSource.BLOCKS, x, y, z, (float)volume, (float)pitch, 0L);
        for (int j = 0; j < worldObj.players().size(); ++j) {
            double zz;
            double yy;
            ServerPlayer player = (ServerPlayer)worldObj.players().get(j);
            BlockPos chunkcoordinates = player.blockPosition();
            double xx = x - (double)chunkcoordinates.getX();
            double sqDist = xx * xx + (yy = y - (double)chunkcoordinates.getY()) * yy + (zz = z - (double)chunkcoordinates.getZ()) * zz;
            if (!(sqDist <= 256.0)) continue;
            player.connection.send((Packet)soundEffect);
        }
    }
}

