/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.entity;

import com.google.auto.service.AutoService;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.BuiltInLootrTypes;
import noobanidus.mods.lootr.common.api.ILootrEntityConverter;
import noobanidus.mods.lootr.common.api.ILootrType;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.SimpleLootrEntityInstance;
import noobanidus.mods.lootr.common.api.data.entity.ILootrEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinItemFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LootrItemFrame
extends ItemFrame
implements ILootrEntity {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final SimpleLootrEntityInstance instance = new SimpleLootrEntityInstance((Entity)this, this::getVisualOpeners, 1);

    public LootrItemFrame(EntityType<? extends ItemFrame> entityType, Level level) {
        super(entityType, level);
    }

    public LootrItemFrame(Level level, BlockPos pos, Direction facingDirection) {
        super(LootrRegistry.getItemFrame(), level, pos, facingDirection);
    }

    public void lootrSetItem(ItemStack stack) {
        stack = stack.copyWithCount(1);
        this.inventory.set(0, (Object)stack);
        if (!this.level().isClientSide()) {
            this.setItemInternal(stack);
        }
    }

    public void startSeenByPlayer(ServerPlayer pPlayer) {
        super.startSeenByPlayer(pPlayer);
        if (this.hasVisualOpened((Player)pPlayer)) {
            this.performOpen(pPlayer);
        } else {
            this.performClose(pPlayer);
        }
    }

    public boolean survives() {
        if (LootrAPI.canItemFramesSelfSupport()) {
            return true;
        }
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        return (blockState.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode((BlockState)blockState)) && this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isInvulnerable() && source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return true;
        }
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (LootrAPI.canDestroyOrBreak(player)) {
                return false;
            }
            if (LootrAPI.isBreakDisabled()) {
                if (player.getAbilities().instabuild) {
                    return !player.isShiftKeyDown();
                }
                return true;
            }
            if (!source.getEntity().isShiftKeyDown()) {
                return true;
            }
            if (source.getEntity().isShiftKeyDown()) {
                return false;
            }
        }
        return true;
    }

    private void maybeMessagePlayer(DamageSource source) {
        Entity entity = source.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.level().isClientSide()) {
                if (LootrAPI.canDestroyOrBreak(player)) {
                    return;
                }
                if (LootrAPI.isBreakDisabled()) {
                    if (player.getAbilities().instabuild) {
                        if (!player.isShiftKeyDown()) {
                            player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break_sneak").setStyle(LootrAPI.getChatStyle()), false);
                        }
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"lootr.message.cannot_break").setStyle(LootrAPI.getChatStyle()), false);
                    }
                } else if (!source.getEntity().isShiftKeyDown()) {
                    ((Player)source.getEntity()).displayClientMessage((Component)Component.translatable((String)"lootr.message.cart_should_sneak").setStyle(LootrAPI.getChatStyle()), false);
                    ((Player)source.getEntity()).displayClientMessage((Component)Component.translatable((String)"lootr.message.cart_should_sneak2").setStyle(LootrAPI.getChatStyle()), false);
                }
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity;
        boolean skipMessage = false;
        if (amount > 0.0f && (entity = source.getEntity()) instanceof ServerPlayer && this.actuallyDropItem(player = (ServerPlayer)entity)) {
            skipMessage = true;
        }
        if (amount > 0.0f && !skipMessage) {
            this.maybeMessagePlayer(source);
        }
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (!this.isRemoved() && !this.level().isClientSide) {
            this.kill();
            this.markHurt();
        }
        return true;
    }

    public void dropItem(@Nullable Entity entity) {
    }

    public void setItem(ItemStack stack, boolean updateNeighbours) {
    }

    private boolean actuallyDropItem(ServerPlayer player) {
        if (this.level().isClientSide()) {
            return false;
        }
        ILootrInventory inventory = LootrAPI.getInventory(this, player);
        if (inventory == null) {
            return false;
        }
        if (inventory.getItem(0).isEmpty()) {
            return false;
        }
        if (!this.hasServerOpened((Player)player)) {
            player.awardStat(LootrRegistry.getLootedStat());
            LootrRegistry.getStatTrigger().trigger(player);
        }
        this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
        inventory.setItem(0, ItemStack.EMPTY);
        inventory.setChanged();
        ItemStack item = this.getItem().copy();
        this.spawnAtLocation(item);
        this.performTrigger(player);
        if (this.addOpener((Player)player)) {
            this.performOpen(player);
        }
        this.performUpdate(player);
        return true;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(AccessorMixinItemFrame.lootr$getDataItem());
    }

    public boolean hasFramedMap() {
        return false;
    }

    public SlotAccess getSlot(int slot) {
        return SlotAccess.NULL;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("customInventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inventory, (HolderLookup.Provider)this.level().registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        ContainerHelper.loadAllItems((CompoundTag)compound.getCompound("customInventory"), this.inventory, (HolderLookup.Provider)this.level().registryAccess());
        this.setItemInternal((ItemStack)this.inventory.getFirst());
    }

    private void setItemInternal(ItemStack stack) {
        if (stack.is(Items.FILLED_MAP)) {
            LootrAPI.LOG.error("ItemFrames with maps are not supported by Lootr Item Frames due to technical limitations.");
            return;
        }
        if (!stack.isEmpty()) {
            stack = stack.copyWithCount(1);
        }
        ((AccessorMixinItemFrame)((Object)this)).lootr$onItemChanged(stack);
        this.getEntityData().set(AccessorMixinItemFrame.lootr$getDataItem(), (Object)stack);
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.level().isClientSide) {
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public int getAnalogOutput() {
        return 0;
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)Items.ITEM_FRAME);
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)Items.ITEM_FRAME);
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.instance.getClientOpeners();
    }

    @Override
    public boolean isClientOpened() {
        return this.instance.isClientOpened();
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.instance.setClientOpened(opened);
    }

    @Override
    public void markChanged() {
        this.markDataChanged();
    }

    @Override
    @Deprecated
    public LootrBlockType getInfoBlockType() {
        return null;
    }

    @Override
    public ILootrType getInfoNewType() {
        return BuiltInLootrTypes.ITEM_FRAME;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        return this.getUUID();
    }

    @Override
    public String getInfoKey() {
        return this.instance.getInfoKey();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.instance.hasBeenOpened();
    }

    @Override
    public boolean isPhysicallyOpen() {
        return false;
    }

    @Override
    @NotNull
    public BlockPos getInfoPos() {
        return BlockPos.containing((Position)this.position());
    }

    @Override
    @Nullable
    public Component getInfoDisplayName() {
        return this.getDisplayName();
    }

    @Override
    @NotNull
    public ResourceKey<Level> getInfoDimension() {
        return this.level().dimension();
    }

    @Override
    public int getInfoContainerSize() {
        return 1;
    }

    @Override
    @Nullable
    public NonNullList<ItemStack> getInfoReferenceInventory() {
        return this.inventory;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return true;
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getInfoLootTable() {
        return LootrAPI.ITEM_FRAME_EMPTY;
    }

    @Override
    public long getInfoLootSeed() {
        return 0L;
    }

    @AutoService(value={ILootrEntityConverter.class})
    public static class DefaultConverter
    implements ILootrEntityConverter<LootrItemFrame> {
        @Override
        public ILootrEntity apply(LootrItemFrame entity) {
            return entity;
        }

        @Override
        public EntityType<?> getEntityType() {
            return LootrRegistry.getItemFrame();
        }
    }
}

