/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot;

import com.almostreliable.lootjs.LootJS;
import com.almostreliable.lootjs.loot.AddAttributesFunction;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetCustomDataFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SetLoreFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.functions.ToggleTooltips;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public interface LootFunctionsContainer<F> {
    default public F enchantRandomly() {
        return this.addFunction(EnchantRandomlyFunction.randomEnchantment().build());
    }

    default public F enchantRandomly(HolderSet<Enchantment> enchantments) {
        EnchantRandomlyFunction.Builder enchantRandomlyFunctionBuilder = EnchantRandomlyFunction.randomEnchantment();
        enchantRandomlyFunctionBuilder.withOneOf(enchantments);
        return this.addFunction(enchantRandomlyFunctionBuilder.build());
    }

    default public F enchantWithLevels(NumberProvider numberProvider) {
        EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.enchantWithLevels((HolderLookup.Provider)LootJS.lookup(), (NumberProvider)numberProvider);
        return this.addFunction(builder.build());
    }

    default public F enchant(boolean add, Consumer<SetEnchantmentsFunction.Builder> action) {
        SetEnchantmentsFunction.Builder builder = new SetEnchantmentsFunction.Builder(add);
        action.accept(builder);
        return this.addFunction(builder.build());
    }

    default public F enchant(Consumer<SetEnchantmentsFunction.Builder> action) {
        return this.enchant(false, action);
    }

    default public F applyEnchantmentBonus(Holder<Enchantment> enchantment, NumberProvider count) {
        return this.addFunction(new EnchantedCountIncreaseFunction.Builder(enchantment, count).build());
    }

    default public F applyEnchantmentBonus(NumberProvider count) {
        return this.addFunction(EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)LootJS.lookup(), (NumberProvider)count).build());
    }

    default public F applyBinomialDistributionBonus(Holder<Enchantment> enchantment, float probability, int extra) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addBonusBinomialDistributionCount(enchantment, (float)probability, (int)extra);
        return this.addFunction(applyBonusBuilder.build());
    }

    default public F applyOreBonus(Holder<Enchantment> enchantment) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addOreBonusCount(enchantment);
        return this.addFunction(applyBonusBuilder.build());
    }

    default public F applyBonus(Holder<Enchantment> enchantment, int multiplier) {
        LootItemConditionalFunction.Builder applyBonusBuilder = ApplyBonusCount.addUniformBonusCount(enchantment, (int)multiplier);
        return this.addFunction(applyBonusBuilder.build());
    }

    default public F simulateExplosionDecay() {
        return this.addFunction(ApplyExplosionDecay.explosionDecay().build());
    }

    default public F smelt() {
        return this.addFunction(SmeltItemFunction.smelted().build());
    }

    default public F damage(NumberProvider numberProvider) {
        return this.addFunction(SetItemDamageFunction.setDamage((NumberProvider)numberProvider).build());
    }

    default public F addPotion(Potion potion) {
        return this.addFunction(SetPotionFunction.setPotion((Holder)BuiltInRegistries.POTION.wrapAsHolder((Object)potion)).build());
    }

    default public F addAttributes(Consumer<AddAttributesFunction.Builder> action) {
        AddAttributesFunction.Builder builder = new AddAttributesFunction.Builder();
        action.accept(builder);
        return this.addFunction(builder.build());
    }

    default public F limitCount(@Nullable NumberProvider numberProviderMin, @Nullable NumberProvider numberProviderMax) {
        IntRange intRange = new IntRange(numberProviderMin, numberProviderMax);
        return this.addFunction(LimitCount.limitCount((IntRange)intRange).build());
    }

    default public F setCount(NumberProvider numberProvider) {
        return this.addFunction(SetItemCountFunction.setCount((NumberProvider)numberProvider).build());
    }

    default public F addLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.setLore();
        for (Component c : components) {
            builder.addLine(c);
        }
        return this.addFunction(builder.build());
    }

    default public F replaceLore(Component ... components) {
        SetLoreFunction.Builder builder = SetLoreFunction.setLore();
        for (Component c : components) {
            builder.addLine(c);
        }
        return this.addFunction(builder.setMode((ListOperation)ListOperation.ReplaceAll.INSTANCE).build());
    }

    default public F setName(Component component) {
        return this.addFunction(SetComponentsFunction.setComponent((DataComponentType)DataComponents.CUSTOM_NAME, (Object)component).build());
    }

    default public F setCustomData(CompoundTag tag) {
        return this.addFunction(SetCustomDataFunction.setCustomData((CompoundTag)tag).build());
    }

    default public F toggleTooltips(Map<String, Boolean> toggles) {
        HashMap map = new HashMap();
        toggles.forEach((name, flag) -> {
            ResourceLocation id = ResourceLocation.parse((String)name);
            DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(id);
            if (type == null) {
                throw new IllegalArgumentException("Component type not found: " + name);
            }
            ToggleTooltips.ComponentToggle toggle = (ToggleTooltips.ComponentToggle)ToggleTooltips.TOGGLES.get(type);
            if (toggle == null) {
                throw new IllegalArgumentException("Can't toggle tooltip visiblity for: " + name);
            }
            map.put(toggle, flag);
        });
        return this.addFunction((LootItemFunction)new ToggleTooltips(List.of(), map));
    }

    default public F jsonFunction(JsonObject json) {
        RegistryOps regOps = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)LootJS.lookup());
        LootItemFunction function = (LootItemFunction)LootItemFunctions.ROOT_CODEC.parse((DynamicOps)regOps, (Object)json).getOrThrow();
        return this.addFunction(function);
    }

    public F addFunction(LootItemFunction var1);
}

