/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.core.filters;

import com.almostreliable.lootjs.core.filters.IdFilter;
import com.almostreliable.lootjs.core.filters.ItemFilter;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.common.ItemAbility;

public class ItemFilterImpl {

    public record AnyOf(ItemFilter[] itemFilters, ItemFilter composite) implements ItemFilter
    {
        private final ItemFilter[] itemFilters;

        public static ItemFilter compose(ItemFilter[] itemFilters) {
            return switch (itemFilters.length) {
                case 0 -> ItemFilter.NONE;
                case 1 -> itemFilters[0];
                case 2 -> {
                    ItemFilter itemFilter1 = itemFilters[0];
                    ItemFilter itemFilter2 = itemFilters[1];
                    yield itemStack -> itemFilter1.test(itemStack) || itemFilter2.test(itemStack);
                }
                default -> itemStack -> {
                    for (ItemFilter itemFilter : itemFilters) {
                        if (!itemFilter.test(itemStack)) continue;
                        return true;
                    }
                    return false;
                };
            };
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.composite.test(itemStack);
        }

        public ItemFilter[] itemFilters() {
            return (ItemFilter[])this.itemFilters.clone();
        }
    }

    public record AllOf(ItemFilter[] itemFilters, ItemFilter composite) implements ItemFilter
    {
        private final ItemFilter[] itemFilters;

        public static ItemFilter compose(ItemFilter[] itemFilters) {
            return switch (itemFilters.length) {
                case 0 -> ItemFilter.ANY;
                case 1 -> itemFilters[0];
                case 2 -> {
                    ItemFilter itemFilter1 = itemFilters[0];
                    ItemFilter itemFilter2 = itemFilters[1];
                    yield itemStack -> itemFilter1.test(itemStack) && itemFilter2.test(itemStack);
                }
                default -> itemStack -> {
                    for (ItemFilter itemFilter : itemFilters) {
                        if (itemFilter.test(itemStack)) continue;
                        return false;
                    }
                    return true;
                };
            };
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.composite.test(itemStack);
        }

        public ItemFilter[] itemFilters() {
            return (ItemFilter[])this.itemFilters.clone();
        }
    }

    public record Not(ItemFilter itemFilter) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return !this.itemFilter.test(itemStack);
        }
    }

    public record Custom(Predicate<ItemStack> predicate, @Nullable String description) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return this.predicate.test(itemStack);
        }
    }

    public record AllOfToolAction(List<ItemAbility> toolActions, Predicate<ItemStack> composite) implements ItemFilter
    {
        public static Predicate<ItemStack> compose(List<ItemAbility> toolActions) {
            if (toolActions.size() == 1) {
                ItemAbility action = toolActions.getFirst();
                return itemStack -> itemStack.canPerformAction(action);
            }
            if (toolActions.isEmpty()) {
                return itemStack -> true;
            }
            if (toolActions.size() == 2) {
                ItemAbility action1 = toolActions.get(0);
                ItemAbility action2 = toolActions.get(1);
                return itemStack -> itemStack.canPerformAction(action1) && itemStack.canPerformAction(action2);
            }
            return itemStack -> {
                for (ItemAbility action : toolActions) {
                    if (itemStack.canPerformAction(action)) continue;
                    return false;
                }
                return true;
            };
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.composite.test(itemStack);
        }
    }

    public record AnyOfToolAction(List<ItemAbility> toolActions, Predicate<ItemStack> composite) implements ItemFilter
    {
        public static Predicate<ItemStack> compose(List<ItemAbility> toolActions) {
            if (toolActions.isEmpty()) {
                return itemStack -> true;
            }
            if (toolActions.size() == 1) {
                ItemAbility action = toolActions.getFirst();
                return itemStack -> itemStack.canPerformAction(action);
            }
            if (toolActions.size() == 2) {
                ItemAbility action1 = toolActions.get(0);
                ItemAbility action2 = toolActions.get(1);
                return itemStack -> itemStack.canPerformAction(action1) || itemStack.canPerformAction(action2);
            }
            return itemStack -> {
                for (ItemAbility action : toolActions) {
                    if (!itemStack.canPerformAction(action)) continue;
                    return true;
                }
                return false;
            };
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.composite.test(itemStack);
        }
    }

    public record ByTag(TagKey<Item> tag) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return itemStack.is(this.tag);
        }
    }

    public record ByIngredient(Ingredient ingredient) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return this.ingredient.test(itemStack);
        }
    }

    public record ByItem(ItemStack filter, boolean checkComponents) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            if (this.checkComponents) {
                return ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)this.filter);
            }
            return itemStack.getItem() == this.filter.getItem();
        }
    }

    public record IsEquipmentSlotGroup(EquipmentSlotGroup equipmentSlotGroup) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            EquipmentSlot equipmentSlot = itemStack.getEquipmentSlot();
            if (equipmentSlot == null) {
                return false;
            }
            return this.equipmentSlotGroup.test(equipmentSlot);
        }
    }

    public record IsEquipmentSlot(EquipmentSlot equipmentSlot) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            return itemStack.getEquipmentSlot() == this.equipmentSlot;
        }
    }

    public record HasComponent(DataComponentType<?>[] types) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            for (DataComponentType<?> type : this.types) {
                if (itemStack.has(type)) continue;
                return false;
            }
            return true;
        }
    }

    public record HasEnchantment(IdFilter filter, MinMaxBounds.Ints levelBounds, DataComponentType<ItemEnchantments> type) implements ItemFilter
    {
        @Override
        public boolean test(ItemStack itemStack) {
            ItemEnchantments enchantments = (ItemEnchantments)itemStack.get(this.type);
            if (enchantments == null) {
                return false;
            }
            return this.hasEnchantmentsInComponent(enchantments);
        }

        public boolean hasEnchantmentsInComponent(ItemEnchantments enchantments) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                boolean matches = ((Holder)entry.getKey()).unwrapKey().filter(key -> this.filter.test(key.location())).isPresent();
                if (!matches || !this.levelBounds.matches(entry.getIntValue())) continue;
                return true;
            }
            return false;
        }
    }
}

