/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lmft.utils;

import io.wispforest.lmft.utils.MethodHandleUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

public class ComponentUtils {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    @Nullable
    private static final Function<String, MutableComponent> mutableComponentEventFactory = ComponentUtils.findConstructor();
    @Nullable
    private static final BiConsumer<MutableComponent, Component> appendMethodCall = ComponentUtils.createAppendHandle();
    private static final BiConsumer<MutableComponent, UnaryOperator<Style>> styleOperatorMethodCall = ComponentUtils.createStyleOperatorMethod();
    private static final BiConsumer<MutableComponent, ChatFormatting[]> styleMethodCall = ComponentUtils.createStyleMethod();

    private static Function<String, MutableComponent> findConstructor() {
        MethodHandle constructor;
        MethodHandle staticConstructor = MethodHandleUtils.findStaticMethod(lookup, Component.class, MethodType.methodType(MutableComponent.class, String.class), "literal", "method_43470", "m_237113_");
        if (staticConstructor != null) {
            return s -> (MutableComponent)MethodHandleUtils.wrapForErrors("createMutableComponentNew", () -> staticConstructor.invoke((String)s));
        }
        Class<?> clazz = MethodHandleUtils.findClass("net.minecraft.network.chat.TextComponent", "net.minecraft.text.LiteralText", "net.minecraft.class_2585", "net.minecraft.src.C_5025_");
        if (clazz != null && (constructor = MethodHandleUtils.findConstructor(lookup, clazz, String.class)) != null) {
            return s -> (MutableComponent)MethodHandleUtils.wrapForErrors("createMutableComponentOld", () -> constructor.invoke((String)s));
        }
        return null;
    }

    public static boolean canCreateMessages() {
        return mutableComponentEventFactory != null;
    }

    @Nullable
    public static MutableComponent createMutableComponent(String text) {
        return mutableComponentEventFactory != null ? mutableComponentEventFactory.apply(text) : null;
    }

    private static BiConsumer<MutableComponent, Component> createAppendHandle() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, MutableComponent.class, MethodType.methodType(MutableComponent.class, Component.class), "append", "method_10852", "m_7220_");
        return method != null ? (component, sibling) -> MethodHandleUtils.wrapForErrors("append", () -> method.invoke((MutableComponent)component, (Component)sibling)) : null;
    }

    public static MutableComponent append(MutableComponent component, Component sibling) {
        if (appendMethodCall != null) {
            appendMethodCall.accept(component, sibling);
        }
        return component;
    }

    private static BiConsumer<MutableComponent, UnaryOperator<Style>> createStyleOperatorMethod() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, MutableComponent.class, MethodType.methodType(MutableComponent.class, UnaryOperator.class), "withStyle", "styled", "method_27694", "m_130938_");
        return method != null ? (component, operator) -> MethodHandleUtils.wrapForErrors("withStyle", () -> method.invoke((MutableComponent)component, (UnaryOperator)operator)) : null;
    }

    public static MutableComponent withStyle(MutableComponent component, UnaryOperator<Style> style) {
        if (styleOperatorMethodCall != null) {
            styleOperatorMethodCall.accept(component, style);
        }
        return component;
    }

    private static BiConsumer<MutableComponent, ChatFormatting[]> createStyleMethod() {
        MethodHandle method = MethodHandleUtils.findMethod(lookup, MutableComponent.class, MethodType.methodType(MutableComponent.class, ChatFormatting[].class), "withStyle", "formatted", "method_27695", "m_130944_");
        return method != null ? (component, operator) -> MethodHandleUtils.wrapForErrors("withStyle", () -> method.invoke((MutableComponent)component, (ChatFormatting[])operator)) : null;
    }

    public static MutableComponent withStyle(MutableComponent component, ChatFormatting ... formats) {
        if (styleMethodCall != null) {
            styleMethodCall.accept(component, formats);
        }
        return component;
    }
}

