/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.block.microchip.MicrochipBlockEntity;
import net.swedz.little_big_redstone.gui.microchip.MicrochipViewPosition;
import net.swedz.little_big_redstone.network.LBRCustomPacket;
import net.swedz.tesseract.neoforge.packet.PacketContext;

public record RequestMicrochipMenuPacket(BlockPos pos, MicrochipViewPosition viewPosition) implements LBRCustomPacket
{
    public static final StreamCodec<ByteBuf, RequestMicrochipMenuPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RequestMicrochipMenuPacket::pos, MicrochipViewPosition.STREAM_CODEC, RequestMicrochipMenuPacket::viewPosition, RequestMicrochipMenuPacket::new);

    public void handle(PacketContext context) {
        context.assertServerbound();
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        String playerName = player.getGameProfile().getName();
        BlockEntity blockEntity = player.level().getBlockEntity(this.pos);
        if (blockEntity instanceof MicrochipBlockEntity) {
            MicrochipBlockEntity blockEntity2 = (MicrochipBlockEntity)blockEntity;
            if (!blockEntity2.openMenu((Player)player, this.viewPosition)) {
                LBR.LOGGER.warn("Received WriteLogicConfigPacket from {} when too far or not in the same dimension or the block entity is removed, discarding", (Object)playerName);
            }
        } else {
            LBR.LOGGER.warn("Received WriteLogicConfigPacket from {} when targeting non-microchip block entity (at {}), discarding", (Object)playerName, (Object)this.pos.toShortString());
        }
    }
}

