/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.reader;

import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRTooltips;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderConfig;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;

final class LogicReaderConfigMenuProvider
extends LogicConfigMenuProvider<LogicReaderConfig> {
    private LogicConfigButtonReference<LogicComparisonMode> comparisonButton;
    private LogicConfigButtonReference<Double> thresholdFillSlider;
    private LogicConfigButtonReference<Double> thresholdSignalSlider;

    public LogicReaderConfigMenuProvider(LogicReaderConfig config) {
        super(config);
    }

    private void updateComparisonButton() {
        if (this.comparisonButton != null) {
            this.comparisonButton.setTooltip((Component)this.tooltipComparison());
        }
    }

    private void updateThresholdSlider() {
        boolean readsSignal = ((LogicReaderConfig)this.config).mode.readsSignal();
        this.thresholdFillSlider.setVisible(!readsSignal);
        this.thresholdSignalSlider.setVisible(readsSignal);
    }

    private void createMode(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addCycleButton((Component)LBR.text().logicConfigButtonLabelMode(), (Component)LBR.text().logicConfigButtonTooltipReaderMode(), 0, 0, width, 18, false, ((LogicReaderConfig)this.config).mode, Arrays.asList(LogicReaderMode.values()), LogicReaderMode::label, value -> {
            boolean changed = value.readsSignal() != ((LogicReaderConfig)this.config).mode.readsSignal();
            ((LogicReaderConfig)this.config).mode = value;
            if (changed) {
                this.updateComparisonButton();
                this.updateThresholdSlider();
            }
        });
    }

    private void createDirection(LogicConfigMenuBuilder builder, int width, int height) {
        builder.addCycleButton((Component)LBR.text().logicConfigButtonLabelDirection(), (Component)LBR.text().logicConfigButtonTooltipReaderDirection(), 0, 22, width, 18, false, ((LogicReaderConfig)this.config).direction, Arrays.asList(Direction.values()), arg_0 -> LBRTooltips.DIRECTION_PARSER.parse(arg_0), value -> {
            ((LogicReaderConfig)this.config).direction = value;
        });
    }

    private MutableComponent tooltipComparison() {
        return ((LogicReaderConfig)this.config).mode.readsSignal() ? this.tooltipSignalComparison() : this.tooltipFillComparison();
    }

    private MutableComponent tooltipFillComparison() {
        return switch (((LogicReaderConfig)this.config).comparison) {
            default -> throw new MatchException(null, null);
            case LogicComparisonMode.LESS_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderThresholdComparisonModeLessThanOrEqualTo(((LogicReaderConfig)this.config).fillThreshold);
            case LogicComparisonMode.EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderThresholdComparisonModeEqualTo(((LogicReaderConfig)this.config).fillThreshold);
            case LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderThresholdComparisonModeGreaterThanOrEqualTo(((LogicReaderConfig)this.config).fillThreshold);
        };
    }

    private MutableComponent tooltipSignalComparison() {
        return switch (((LogicReaderConfig)this.config).comparison) {
            default -> throw new MatchException(null, null);
            case LogicComparisonMode.LESS_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderSignalComparisonModeLessThanOrEqualTo(((LogicReaderConfig)this.config).signalThreshold);
            case LogicComparisonMode.EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderSignalComparisonModeEqualTo(((LogicReaderConfig)this.config).signalThreshold);
            case LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO -> LBR.text().logicConfigButtonTooltipReaderSignalComparisonModeGreaterThanOrEqualTo(((LogicReaderConfig)this.config).signalThreshold);
        };
    }

    private void createComparison(LogicConfigMenuBuilder builder, int width, int height) {
        this.comparisonButton = builder.addCycleButton((Component)this.tooltipComparison(), 0, 44, LBR.id("textures/gui/slot_atlas.png"), ((LogicReaderConfig)this.config).comparison, Arrays.asList(LogicComparisonMode.values()), value -> {
            ((LogicReaderConfig)this.config).comparison = value;
            this.updateComparisonButton();
        });
        this.updateComparisonButton();
    }

    private void createThreshold(LogicConfigMenuBuilder builder, int width, int height) {
        this.thresholdFillSlider = builder.addSlider((Component)LBR.text().logicConfigButtonLabelReaderFillThreshold(), (Component)Component.literal((String)"%"), (Component)LBR.text().logicConfigButtonTooltipReaderFillThreshold(), 22, 44, width - 18 - 4, 18, 0.0, 100.0, ((LogicReaderConfig)this.config).fillThreshold * 100.0f, 1.0, 0, value -> {
            ((LogicReaderConfig)this.config).fillThreshold = (float)(value / 100.0);
            this.updateComparisonButton();
        }).setVisible(false);
        this.thresholdSignalSlider = builder.addSlider((Component)LBR.text().logicConfigButtonLabelReaderSignalThreshold(), (Component)Component.empty(), (Component)LBR.text().logicConfigButtonTooltipReaderSignalThreshold(), 22, 44, width - 18 - 4, 18, 1.0, 15.0, ((LogicReaderConfig)this.config).signalThreshold, 1.0, 0, value -> {
            ((LogicReaderConfig)this.config).signalThreshold = value.intValue();
            this.updateComparisonButton();
        }).setVisible(false);
        this.updateThresholdSlider();
    }

    @Override
    public void create(LogicConfigMenuBuilder builder, int width, int height) {
        this.createMode(builder, width, height);
        this.createDirection(builder, width, height);
        this.createComparison(builder, width, height);
        this.createThreshold(builder, width, height);
    }
}

