/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.reader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicComparisonMode;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderConfigMenuProvider;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;
import net.swedz.tesseract.neoforge.api.range.IntRange;
import net.swedz.tesseract.neoforge.helper.CodecHelper;

public final class LogicReaderConfig
extends LogicConfig<LogicReaderConfig> {
    public static final MapCodec<LogicReaderConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecHelper.forLowercaseEnum(LogicReaderMode.class).optionalFieldOf("mode", (Object)LogicReaderMode.ITEM).forGetter(config -> config.mode), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.NORTH).forGetter(config -> config.direction), (App)Codec.FLOAT.optionalFieldOf("fill_threshold", (Object)Float.valueOf(0.5f)).forGetter(config -> Float.valueOf(config.fillThreshold)), (App)Codec.intRange((int)1, (int)15).optionalFieldOf("signal_threshold", (Object)1).forGetter(config -> config.signalThreshold), (App)CodecHelper.forLowercaseEnum(LogicComparisonMode.class).optionalFieldOf("comparison", (Object)LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO).forGetter(config -> config.comparison)).apply((Applicative)instance, LogicReaderConfig::new));
    public static final StreamCodec<ByteBuf, LogicReaderConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)CodecHelper.forLowercaseEnumStream(LogicReaderMode.class), config -> config.mode, (StreamCodec)Direction.STREAM_CODEC, config -> config.direction, (StreamCodec)ByteBufCodecs.FLOAT, config -> Float.valueOf(config.fillThreshold), (StreamCodec)ByteBufCodecs.INT, config -> config.signalThreshold, (StreamCodec)CodecHelper.forEnumStream(LogicComparisonMode.class), config -> config.comparison, LogicReaderConfig::new);
    public LogicReaderMode mode;
    public Direction direction;
    public float fillThreshold;
    public int signalThreshold;
    public LogicComparisonMode comparison;

    private LogicReaderConfig(LogicReaderMode mode, Direction direction, float fillThreshold, int signalThreshold, LogicComparisonMode comparison) {
        this.mode = mode;
        this.direction = direction;
        this.fillThreshold = fillThreshold;
        this.signalThreshold = signalThreshold;
        this.comparison = comparison;
    }

    public LogicReaderConfig() {
        this(LogicReaderMode.ITEM, Direction.NORTH, 0.5f, 1, LogicComparisonMode.GREATER_THAN_OR_EQUAL_TO);
    }

    @Override
    public IntRange inputsAllowed() {
        return new IntRange(0, 0);
    }

    @Override
    public int inputs() {
        return 0;
    }

    @Override
    public IntRange outputsAllowed() {
        return new IntRange(1, 1);
    }

    @Override
    public int outputs() {
        return 1;
    }

    @Override
    public void appendHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicConfigTooltipMode(this.mode));
        lines.add((Component)LBR.text().logicConfigTooltipDirection(this.direction));
        lines.add((Component)(this.mode.readsSignal() ? LBR.text().logicConfigTooltipReaderSignalComparison(this.comparison, this.signalThreshold) : LBR.text().logicConfigTooltipReaderFillComparison(this.comparison, this.fillThreshold)));
    }

    @Override
    public boolean hasMenu() {
        return true;
    }

    @Override
    public LogicConfigMenuProvider getMenuProvider() {
        return new LogicReaderConfigMenuProvider(this);
    }

    @Override
    protected void internalLoadFrom(LogicReaderConfig other) {
        this.mode = other.mode;
        this.direction = other.direction;
        this.fillThreshold = other.fillThreshold;
        this.signalThreshold = other.signalThreshold;
        this.comparison = other.comparison;
    }

    @Override
    public void resetForPickup() {
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mode, this.direction, Float.valueOf(this.fillThreshold), this.signalThreshold, this.comparison);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicReaderConfig)) return false;
        LogicReaderConfig other = (LogicReaderConfig)o;
        if (this.mode != other.mode) return false;
        if (this.direction != other.direction) return false;
        if (this.fillThreshold != other.fillThreshold) return false;
        if (this.signalThreshold != other.signalThreshold) return false;
        if (this.comparison != other.comparison) return false;
        return true;
    }
}

