/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.reader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessType;
import net.swedz.little_big_redstone.microchip.awareness.AwarenessTypes;
import net.swedz.little_big_redstone.microchip.awareness.MicrochipAware;
import net.swedz.little_big_redstone.microchip.awareness.types.AnalogSignalAwareness;
import net.swedz.little_big_redstone.microchip.awareness.types.capability.EnergyCapabilityAwareness;
import net.swedz.little_big_redstone.microchip.awareness.types.capability.FluidCapabilityAwareness;
import net.swedz.little_big_redstone.microchip.awareness.types.capability.ItemCapabilityAwareness;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderConfig;
import net.swedz.little_big_redstone.microchip.object.logic.reader.LogicReaderMode;

public final class LogicReader
extends LogicComponent<LogicReader, LogicReaderConfig>
implements MicrochipAware {
    public static final MapCodec<LogicReader> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LogicReaderConfig.CODEC.fieldOf("config").forGetter(LogicComponent::config), (App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(LogicReader::output)).apply((Applicative)instance, LogicReader::new));
    public static final StreamCodec<ByteBuf, LogicReader> STREAM_CODEC = StreamCodec.composite(LogicReaderConfig.STREAM_CODEC, LogicComponent::config, (StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, LogicReader::output, LogicReader::new);
    private boolean outputState;

    private LogicReader(LogicReaderConfig config, Optional<DyeColor> color, boolean outputState) {
        super(config, color);
        this.outputState = outputState;
    }

    private LogicReader(Optional<DyeColor> color, boolean outputState) {
        super(color);
        this.outputState = outputState;
    }

    public LogicReader() {
        this(Optional.empty(), false);
    }

    @Override
    public AwarenessType<?>[] awarenessTypes() {
        AwarenessType[] awarenessTypeArray = new AwarenessType[1];
        awarenessTypeArray[0] = switch (((LogicReaderConfig)this.config).mode) {
            default -> throw new MatchException(null, null);
            case LogicReaderMode.ITEM -> AwarenessTypes.CAPABILITY_ITEM;
            case LogicReaderMode.FLUID -> AwarenessTypes.CAPABILITY_FLUID;
            case LogicReaderMode.ENERGY -> AwarenessTypes.CAPABILITY_ENERGY;
            case LogicReaderMode.COMPARATOR -> AwarenessTypes.ANALOG_SIGNAL;
        };
        return awarenessTypeArray;
    }

    @Override
    protected LogicReaderConfig defaultConfig() {
        return new LogicReaderConfig();
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean originalOutputState = this.outputState;
        float fill = 0.0f;
        int signal = 0;
        if (context.level() instanceof ServerLevel) {
            if (((LogicReaderConfig)this.config).mode == LogicReaderMode.ITEM) {
                ItemCapabilityAwareness awareness = context.awareness(AwarenessTypes.CAPABILITY_ITEM);
                IItemHandler handler = (IItemHandler)awareness.get(context.level(), context.pos(), ((LogicReaderConfig)this.config).direction);
                if (handler != null) {
                    int totalItems = 0;
                    int maxItems = 0;
                    for (int slot = 0; slot < handler.getSlots(); ++slot) {
                        ItemStack stack = handler.getStackInSlot(slot);
                        if (stack.isEmpty()) {
                            maxItems += Mth.clamp((int)handler.getSlotLimit(slot), (int)0, (int)64);
                            continue;
                        }
                        totalItems += stack.getCount();
                        maxItems += stack.getMaxStackSize();
                    }
                    fill = (float)totalItems / (float)maxItems;
                }
            } else if (((LogicReaderConfig)this.config).mode == LogicReaderMode.FLUID) {
                FluidCapabilityAwareness awareness = context.awareness(AwarenessTypes.CAPABILITY_FLUID);
                IFluidHandler handler = (IFluidHandler)awareness.get(context.level(), context.pos(), ((LogicReaderConfig)this.config).direction);
                if (handler != null) {
                    int totalFluid = 0;
                    int maxFluid = 0;
                    for (int tank = 0; tank < handler.getTanks(); ++tank) {
                        totalFluid += handler.getFluidInTank(tank).getAmount();
                        maxFluid += handler.getTankCapacity(tank);
                    }
                    fill = (float)totalFluid / (float)maxFluid;
                }
            } else if (((LogicReaderConfig)this.config).mode == LogicReaderMode.ENERGY) {
                EnergyCapabilityAwareness awareness = context.awareness(AwarenessTypes.CAPABILITY_ENERGY);
                IEnergyStorage handler = (IEnergyStorage)awareness.get(context.level(), context.pos(), ((LogicReaderConfig)this.config).direction);
                if (handler != null) {
                    int totalEnergy = handler.getEnergyStored();
                    int maxEnergy = handler.getMaxEnergyStored();
                    fill = (float)totalEnergy / (float)maxEnergy;
                }
            } else if (((LogicReaderConfig)this.config).mode == LogicReaderMode.COMPARATOR) {
                AnalogSignalAwareness awareness = context.awareness(AwarenessTypes.ANALOG_SIGNAL);
                signal = awareness.getSignal(((LogicReaderConfig)this.config).direction);
            }
        }
        boolean bl = this.outputState = ((LogicReaderConfig)this.config).mode.readsSignal() ? ((LogicReaderConfig)this.config).comparison.test(signal, ((LogicReaderConfig)this.config).signalThreshold) : ((LogicReaderConfig)this.config).comparison.test(Float.valueOf(fill), Float.valueOf(((LogicReaderConfig)this.config).fillThreshold));
        if (this.outputState != originalOutputState) {
            context.markDirty(this);
        }
    }

    @Override
    public LogicType<LogicReader> type() {
        return LogicTypes.READER;
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicHelpReader1());
        lines.add((Component)LBR.text().logicHelpReader2());
    }

    @Override
    protected void internalLoadFrom(LogicReader other) {
        this.outputState = other.outputState;
    }

    @Override
    public void internalResetForPickup() {
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.config, this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof LogicReader)) return false;
        LogicReader other = (LogicReader)o;
        if (!Objects.equals(this.config, other.config)) return false;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

