/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic.latch.rs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicContext;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.little_big_redstone.microchip.object.logic.latch.rs.RSNORLatchConfig;

public final class RSNORLatch
extends LogicComponent<RSNORLatch, RSNORLatchConfig> {
    public static final MapCodec<RSNORLatch> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(LogicComponent::color), (App)Codec.BOOL.optionalFieldOf("output", (Object)false).forGetter(RSNORLatch::output)).apply((Applicative)instance, RSNORLatch::new));
    public static final StreamCodec<ByteBuf, RSNORLatch> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)DyeColor.STREAM_CODEC), LogicComponent::color, (StreamCodec)ByteBufCodecs.BOOL, RSNORLatch::output, RSNORLatch::new);
    private boolean outputState;

    private RSNORLatch(Optional<DyeColor> color, boolean outputState) {
        super(color);
        this.outputState = outputState;
    }

    public RSNORLatch() {
        this(Optional.empty(), false);
    }

    @Override
    protected RSNORLatchConfig defaultConfig() {
        return new RSNORLatchConfig();
    }

    @Override
    public LogicType<RSNORLatch> type() {
        return LogicTypes.RS_NOR_LATCH;
    }

    @Override
    protected void processTickInternal(LogicContext context, boolean[] inputs) {
        boolean originalOutputState = this.outputState;
        boolean set = inputs[0];
        boolean reset = inputs[1];
        if (reset) {
            this.outputState = false;
        } else if (set) {
            this.outputState = true;
        }
        if (originalOutputState != this.outputState) {
            context.markDirty(this);
        }
    }

    @Override
    protected boolean outputInternal(int index) {
        return this.outputState;
    }

    public boolean output() {
        return this.output(0);
    }

    @Override
    public void appendShiftHoverText(List<Component> lines) {
        lines.add((Component)LBR.text().logicHelpRSNORLatch1());
        lines.add((Component)LBR.text().logicHelpRSNORLatch2());
    }

    @Override
    protected void internalLoadFrom(RSNORLatch other) {
        this.outputState = other.outputState;
    }

    @Override
    protected void internalResetForPickup() {
        this.outputState = false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type(), this.color);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof RSNORLatch)) return false;
        RSNORLatch other = (RSNORLatch)o;
        if (!Objects.equals(this.color, other.color)) return false;
        return true;
    }
}

