/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.microchip.object.logic;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicFactory;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;

public record LogicType<L extends LogicComponent>(String id, String englishName, char symbol, MapCodec<L> codec, StreamCodec<ByteBuf, L> streamCodec, LogicFactory defaultFactory) {
    public MutableComponent displayName() {
        return Component.translatable((String)LBR.id(this.id).toLanguageKey("item"));
    }

    public MutableComponent displaySymbol() {
        return Component.literal((String)String.valueOf(this.symbol)).withStyle(Style.EMPTY.withFont(LBR.id("logic_component")));
    }

    public Optional<List<Component>> tooltip(L component, boolean shift, boolean config, boolean configHeader) {
        ArrayList lines = Lists.newArrayList();
        ArrayList noShiftLines = Lists.newArrayList();
        ((LogicComponent)component).appendNoShiftHoverText(noShiftLines);
        if (shift) {
            if (!noShiftLines.isEmpty()) {
                lines.add(Component.empty());
            }
            ((LogicComponent)component).appendShiftHoverText(lines);
        } else {
            lines.addAll(noShiftLines);
        }
        if (config) {
            ArrayList configLines = Lists.newArrayList();
            ((LogicConfig)((LogicComponent)component).config()).appendHoverText(configLines);
            if (!configLines.isEmpty()) {
                if (!lines.isEmpty()) {
                    lines.add(Component.empty());
                }
                if (configHeader) {
                    lines.add(LBR.text().logicConfigTooltip());
                }
                lines.addAll(configLines);
            }
        }
        return lines.isEmpty() ? Optional.empty() : Optional.of(lines);
    }

    public Optional<List<Component>> tooltip(L component, boolean shift, boolean config) {
        return this.tooltip(component, shift, config, true);
    }

    public Item item() {
        return LBRItems.valueOf(this.id).asItem();
    }

    public ItemStack toStack(L component) {
        ItemStack stack = new ItemStack((ItemLike)this.item());
        Object copy = ((LogicComponent)component).copy();
        ((LogicComponent)copy).resetForPickup();
        stack.set(LBRComponents.LOGIC, copy);
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LogicType)) return false;
        LogicType other = (LogicType)o;
        if (!this.id.equals(other.id)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }
}

