/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.scene;

import guideme.color.ColorValue;
import guideme.color.ConstantColor;
import guideme.color.MutableColor;
import guideme.document.interaction.GuideTooltip;
import guideme.document.interaction.TextTooltip;
import guideme.scene.ImplicitAnnotationStrategy;
import guideme.scene.annotation.InWorldBoxAnnotation;
import guideme.scene.annotation.SceneAnnotation;
import guideme.scene.level.GuidebookLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.swedz.little_big_redstone.LBR;

public final class InputOutputImplicitAnnotationStrategy
implements ImplicitAnnotationStrategy {
    public SceneAnnotation getAnnotation(GuidebookLevel level, BlockState state, BlockHitResult hitResult) {
        MutableComponent tooltip;
        int colorRGB;
        if (state.is(Blocks.REDSTONE_WIRE)) {
            state = level.getBlockState(hitResult.getBlockPos().below());
        }
        if (state.is(Blocks.LIGHT_BLUE_CONCRETE)) {
            colorRGB = 2460360;
            tooltip = LBR.text().guideTooltipInputA();
        } else if (state.is(Blocks.CYAN_CONCRETE)) {
            colorRGB = 2460360;
            tooltip = LBR.text().guideTooltipInputB();
        } else if (state.is(Blocks.ORANGE_CONCRETE)) {
            colorRGB = 14770946;
            tooltip = LBR.text().guideTooltipOutput();
        } else {
            return null;
        }
        MutableColor color = MutableColor.of((ColorValue)new ConstantColor(0xFF000000 | colorRGB), null);
        InWorldBoxAnnotation annotation = InWorldBoxAnnotation.forBlock((BlockPos)hitResult.getBlockPos(), (ColorValue)color.copy());
        color.lighter(50.0f);
        annotation.setTooltip((GuideTooltip)new TextTooltip((Component)tooltip.withColor(color.resolve(null)), new Component[0]));
        return annotation;
    }
}

