/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip.element;

import com.google.common.collect.Lists;
import guideme.document.interaction.GuideTooltip;
import guideme.siteexport.ResourceExporter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;

public final class MicrochipObjectGuideTooltip
implements GuideTooltip {
    private final ItemStack icon;
    private final List<ClientTooltipComponent> lines;

    public MicrochipObjectGuideTooltip(MicrochipObject object) {
        this.icon = object.toStack();
        if (object instanceof LogicEntry) {
            LogicEntry logic = (LogicEntry)object;
            LogicComponent component = logic.component();
            ArrayList lines = Lists.newArrayList();
            lines.add(component.type().displayName().withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true))));
            component.type().tooltip(component, false, true, false).ifPresent(lines::addAll);
            this.lines = lines.stream().map(line -> new ClientTextTooltip(line.getVisualOrderText())).toList();
        } else {
            this.lines = List.of();
        }
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public List<ClientTooltipComponent> getLines() {
        return this.lines;
    }

    public void exportResources(ResourceExporter exporter) {
    }
}

