/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.guide.tags.microchip;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.Direction;
import net.swedz.little_big_redstone.microchip.awareness.types.RedstoneAwareness;

public final class TimedRedstoneSignals {
    private static final int INTERVAL = 30;
    private final int[] fallback = new int[6];
    private final Map<Integer, int[]> signals = Maps.newHashMap();
    private long tick;
    private int step;

    public void applySignals(RedstoneAwareness redstone) {
        int[] signals = this.signals.get(this.step);
        if (signals == null) {
            signals = this.fallback;
        }
        for (Direction direction : Direction.values()) {
            int signal = signals[direction.ordinal()];
            redstone.setInputPowered(direction, signal);
        }
    }

    public void setSignal(Integer step, Direction direction, int signal) {
        int[] signals = step == null ? this.fallback : this.signals.computeIfAbsent(step, __ -> new int[6]);
        signals[direction.ordinal()] = signal;
    }

    public void tick() {
        ++this.tick;
        if (this.tick % 30L == 0L) {
            this.tick = 0L;
            this.step = this.step == this.signals.size() - 1 ? 0 : ++this.step;
        }
    }

    public void reset() {
        this.tick = 0L;
        this.step = 0;
    }
}

