/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.edit;

import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.swedz.little_big_redstone.gui.stickynote.edit.StickyNoteEdit;
import net.swedz.tesseract.neoforge.api.Bounds;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class StickyNoteEditWidget
implements GuiEventListener,
Renderable,
NarratableEntry {
    private final Font font;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final StickyNoteEdit note;
    private final Supplier<Integer> color;
    private int tick;
    private boolean focused;

    public StickyNoteEditWidget(Font font, int x, int y, int width, int height, String text, Supplier<Integer> color) {
        this.font = font;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.note = new StickyNoteEdit(font, width, height, text);
        this.color = color;
    }

    public StickyNoteEditWidget(Font font, int x, int y, int width, int height, StickyNoteEditWidget previous, Supplier<Integer> color) {
        this.font = font;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.note = previous.note;
        this.color = color;
    }

    public StickyNoteEdit note() {
        return this.note;
    }

    public void tick() {
        ++this.tick;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            int localMouseX = (int)(mouseX - (double)this.x);
            int localMouseY = (int)(mouseY - (double)this.y);
            this.note.jumpTo(localMouseX, localMouseY, Screen.hasShiftDown());
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            int localMouseX = (int)(mouseX - (double)this.x);
            int localMouseY = (int)(mouseY - (double)this.y);
            this.note.jumpTo(localMouseX, localMouseY, true);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Screen.isSelectAll((int)keyCode)) {
            this.note.selectAll();
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            this.note.copy();
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.note.paste();
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            this.note.cut();
            return true;
        }
        boolean ctrl = Screen.hasControlDown();
        boolean shift = Screen.hasShiftDown();
        return switch (keyCode) {
            case 257, 335 -> {
                this.note.insertNewLine();
                yield true;
            }
            case 259 -> {
                this.note.backspace(ctrl);
                yield true;
            }
            case 261 -> {
                this.note.delete(ctrl);
                yield true;
            }
            case 263 -> {
                this.note.moveLeft(shift, ctrl);
                yield true;
            }
            case 262 -> {
                this.note.moveRight(shift, ctrl);
                yield true;
            }
            case 265 -> {
                this.note.moveUp(shift);
                yield true;
            }
            case 264 -> {
                this.note.moveDown(shift);
                yield true;
            }
            default -> false;
        };
    }

    public boolean charTyped(char character, int modifiers) {
        return this.note.type(character);
    }

    public void render(GuiGraphics vanilla, int mouseX, int mouseY, float partialTick) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.x, (float)this.y, 0.0f);
        this.renderLines(graphics);
        this.renderHighlights(graphics);
        this.renderCursor(graphics);
        graphics.pose().popPose();
    }

    private void renderLines(TesseractGuiGraphics graphics) {
        graphics.setColor(this.color.get().intValue());
        graphics.setStringDropShadow(false);
        StickyNoteEdit.Display display = this.note.getDisplay();
        for (StickyNoteEdit.DisplayLine line : display.lines()) {
            graphics.drawString(line.text(), 0, line.y());
        }
        graphics.setStringDropShadow(true);
        graphics.resetColor();
    }

    private void renderCursor(TesseractGuiGraphics graphics) {
        if (this.isFocused() && this.tick / 6 % 2 == 0) {
            graphics.setColor(this.color.get().intValue());
            StickyNoteEdit.Display display = this.note.getDisplay();
            int x = display.cursorScreenX();
            int y = display.cursorScreenY();
            if (display.isCursorAtEndOfLine()) {
                graphics.setStringDropShadow(false);
                graphics.drawString("_", x, y);
                graphics.setStringDropShadow(true);
            } else {
                graphics.fill(x - 1, y - 1, x, y + display.lineHeight());
            }
            graphics.resetColor();
        }
    }

    private void renderHighlights(TesseractGuiGraphics graphics) {
        for (Bounds area : this.note.getDisplay().highlightedAreas()) {
            this.renderHighlight(graphics, area);
        }
    }

    private void renderHighlight(TesseractGuiGraphics graphics, Bounds area) {
        graphics.setColor(0.0f, 0.0f, 1.0f, 1.0f);
        graphics.fill(RenderType.guiTextHighlight(), area.minX(), area.minY(), area.maxX(), area.maxY());
        graphics.revertColor();
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.getRectangle().containsPoint((int)mouseX, (int)mouseY);
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.x, this.y, this.width, this.height);
    }

    public void setFocused(boolean value) {
        this.focused = value;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }
}

