/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.microchip.widget;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBRItems;
import net.swedz.little_big_redstone.gui.microchip.logic.DyeComponentResult;
import net.swedz.little_big_redstone.gui.microchip.panel.MicrochipRenderBoardPanel;
import net.swedz.little_big_redstone.gui.microchip.widget.MicrochipWidget;
import net.swedz.little_big_redstone.microchip.Microchip;
import net.swedz.little_big_redstone.microchip.object.MicrochipObject;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.LogicSelectedPort;
import net.swedz.little_big_redstone.microchip.object.note.StickyNoteEntry;
import net.swedz.little_big_redstone.microchip.wire.Wire;

public final class MicrochipWidgetContext {
    private final boolean onBoard;
    private final MicrochipWidget widget;
    private final int boardMouseX;
    private final int boardMouseY;
    private final ItemStack carriedStack;
    private final MicrochipObject object;
    private final StickyNoteEntry note;
    private final LogicEntry logic;
    private final LogicSelectedPort port;
    private final boolean portInput;
    private final Wire wire;
    private final List<Wire> topLayerWires;

    public static boolean canInteractWire(ItemStack stack) {
        return stack.isEmpty() || stack.is(LBRItems.REDSTONE_BIT.asItem());
    }

    public static boolean canInteractDyeableObject(ItemStack stack) {
        return stack.isEmpty() || DyeComponentResult.is(stack);
    }

    public static MicrochipWidgetContext test(MicrochipWidget widget, MicrochipRenderBoardPanel panel, int mouseX, int mouseY, int boardMouseX, int boardMouseY, MicrochipWidgetContext previous) {
        LogicEntry o;
        StickyNoteEntry o2;
        if (!widget.isMouseOver(mouseX, mouseY)) {
            return new MicrochipWidgetContext(widget, boardMouseX, boardMouseY);
        }
        Microchip microchip = widget.microchip();
        ItemStack carriedStack = widget.menu().getCarried();
        ArrayList topLayerWires = Lists.newArrayList();
        MicrochipObject object = microchip.findAt(boardMouseX, boardMouseY);
        StickyNoteEntry note = MicrochipWidgetContext.canInteractDyeableObject(carriedStack) && object instanceof StickyNoteEntry ? (o2 = (StickyNoteEntry)object) : null;
        LogicEntry logic = MicrochipWidgetContext.canInteractDyeableObject(carriedStack) && object instanceof LogicEntry ? (o = (LogicEntry)object) : null;
        LogicSelectedPort port = null;
        boolean portInput = true;
        Wire wire = null;
        if (MicrochipWidgetContext.canInteractWire(carriedStack) && object == null) {
            port = microchip.components().findPortAt(boardMouseX, boardMouseY, true);
            if (port == null) {
                port = microchip.components().findPortAt(boardMouseX, boardMouseY, false);
                if (port != null) {
                    List<Wire> wires;
                    portInput = false;
                    if (carriedStack.isEmpty() && !(wires = microchip.wires().getByOutputSlot(port)).isEmpty()) {
                        wire = wires.getLast();
                    }
                }
            } else {
                wire = microchip.wires().getByInputSlot(port);
            }
            if (port != null) {
                logic = (LogicEntry)microchip.components().get(port.slot());
            }
            if (logic == null && !widget.hasSelectedPort()) {
                wire = previous.wire();
                if (wire == null || !panel.wires().isHovering(wire, boardMouseX, boardMouseY)) {
                    wire = panel.wires().findHoveredWire(boardMouseX, boardMouseY);
                    if (wire != null) {
                        logic = (LogicEntry)microchip.components().get(wire.output().slot());
                    }
                } else if (wire != null && panel.wires().isHovering(wire, boardMouseX, boardMouseY)) {
                    logic = (LogicEntry)microchip.components().get(wire.output().slot());
                }
            }
        }
        if (logic != null) {
            int outputSlot = logic.slot();
            if (wire != null) {
                outputSlot = wire.output().slot();
            }
            topLayerWires.addAll(microchip.wires().getByOutputSlot(outputSlot));
            if (wire != null) {
                topLayerWires.remove(wire);
                topLayerWires.add(wire);
            }
        }
        return new MicrochipWidgetContext(widget, boardMouseX, boardMouseY, carriedStack, object, note, logic, port, portInput, wire, topLayerWires);
    }

    private MicrochipWidgetContext(MicrochipWidget widget, int boardMouseX, int boardMouseY, ItemStack carriedStack, MicrochipObject object, StickyNoteEntry note, LogicEntry logic, LogicSelectedPort port, boolean portInput, Wire wire, List<Wire> topLayerWires) {
        this.onBoard = true;
        this.widget = widget;
        this.boardMouseX = boardMouseX;
        this.boardMouseY = boardMouseY;
        this.carriedStack = carriedStack;
        this.object = object;
        this.note = note;
        this.logic = logic;
        this.port = port;
        this.portInput = portInput;
        this.wire = wire;
        this.topLayerWires = Collections.unmodifiableList(topLayerWires);
    }

    public MicrochipWidgetContext(MicrochipWidget widget, int boardMouseX, int boardMouseY) {
        this.onBoard = false;
        this.widget = widget;
        this.boardMouseX = boardMouseX;
        this.boardMouseY = boardMouseY;
        this.carriedStack = ItemStack.EMPTY;
        this.object = null;
        this.note = null;
        this.logic = null;
        this.port = null;
        this.portInput = true;
        this.wire = null;
        this.topLayerWires = List.of();
    }

    public boolean isOnBoard() {
        return this.onBoard;
    }

    public MicrochipWidget widget() {
        return this.widget;
    }

    public int boardMouseX() {
        return this.boardMouseX;
    }

    public int boardMouseY() {
        return this.boardMouseY;
    }

    public ItemStack getCarriedStack() {
        return this.carriedStack;
    }

    public MicrochipObject object() {
        return this.object;
    }

    public boolean hasObject() {
        return this.object != null;
    }

    public StickyNoteEntry note() {
        return this.note;
    }

    public boolean hasNote() {
        return this.note != null;
    }

    public LogicEntry logic() {
        return this.logic;
    }

    public boolean hasLogic() {
        return this.logic != null;
    }

    public LogicSelectedPort port() {
        return this.port;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public boolean isPortInput() {
        return this.portInput;
    }

    public boolean isPortOutput() {
        return !this.portInput;
    }

    public boolean isPortEmpty() {
        return !this.hasWire();
    }

    public Wire wire() {
        return this.wire;
    }

    public boolean hasWire() {
        return this.wire != null;
    }

    public List<Wire> topLayerWires() {
        return this.topLayerWires;
    }

    public boolean shouldRenderTooltip() {
        return this.hasObject() && !this.hasPort() && !this.hasWire() && this.carriedStack.isEmpty();
    }

    public boolean shouldDyeObject() {
        return this.hasObject() && !this.hasPort() && !this.hasWire() && MicrochipWidgetContext.canInteractDyeableObject(this.carriedStack);
    }

    public boolean shouldInteractNote() {
        return this.hasNote() && !this.hasPort() && !this.hasWire() && MicrochipWidgetContext.canInteractDyeableObject(this.carriedStack);
    }

    public boolean shouldInteractLogic() {
        return this.hasLogic() && !this.hasPort() && !this.hasWire() && MicrochipWidgetContext.canInteractDyeableObject(this.carriedStack);
    }

    public boolean shouldInteractPort() {
        return this.hasLogic() && this.hasPort() && MicrochipWidgetContext.canInteractWire(this.carriedStack);
    }

    public boolean shouldInteractWire() {
        return this.hasWire() && MicrochipWidgetContext.canInteractWire(this.carriedStack);
    }

    public boolean shouldInteractBoard() {
        return !this.hasLogic() && !this.hasPort() && !this.hasWire();
    }

    public boolean shouldInsertWireToPort() {
        return this.shouldInteractPort() && this.isPortInput() && this.isPortEmpty();
    }
}

