/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.logicconfig;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.client.model.logic.LogicBakingModelData;
import net.swedz.little_big_redstone.client.model.logic.LogicModelColorSet;
import net.swedz.little_big_redstone.gui.logicconfig.LogicConfigMenu;
import net.swedz.little_big_redstone.gui.logicconfig.button.LogicConfigButton;
import net.swedz.little_big_redstone.gui.logicconfig.button.cycle.CycleLogicConfigButton;
import net.swedz.little_big_redstone.gui.logicconfig.button.iconcycle.CheckboxState;
import net.swedz.little_big_redstone.gui.logicconfig.button.iconcycle.IconCycleLogicConfigButton;
import net.swedz.little_big_redstone.gui.logicconfig.button.iconcycle.IconCycleLogicConfigButtonIcon;
import net.swedz.little_big_redstone.gui.logicconfig.button.slider.SliderLogicConfigButton;
import net.swedz.little_big_redstone.microchip.object.logic.LogicComponent;
import net.swedz.little_big_redstone.microchip.object.logic.LogicEntry;
import net.swedz.little_big_redstone.microchip.object.logic.config.LogicConfig;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigButtonReference;
import net.swedz.little_big_redstone.microchip.object.logic.config.menu.LogicConfigMenuBuilder;
import net.swedz.little_big_redstone.network.packet.RequestMicrochipMenuPacket;
import net.swedz.little_big_redstone.network.packet.WriteLogicConfigPacket;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class LogicConfigScreen
extends AbstractContainerScreen<LogicConfigMenu>
implements LogicConfigMenuBuilder {
    private final int color;
    private final LogicEntry logicEntry;
    private final ItemStack logicStack;
    private int configX;
    private int configY;
    private int configWidth;
    private int configHeight;

    public LogicConfigScreen(LogicConfigMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 196;
        this.inventoryLabelY = this.imageHeight - 94;
        this.configWidth = 156;
        this.configHeight = 176;
        LogicComponent component = menu.logicEntry().component();
        LogicModelColorSet colorSet = LogicBakingModelData.get(component).getColorSet(component, menu.color());
        this.color = colorSet.foreground();
        this.logicEntry = menu.logicEntry();
        this.logicStack = this.logicEntry.toStack();
        Object stackComponent = ((LogicComponent)this.logicStack.get(LBRComponents.LOGIC)).copy();
        ((LogicComponent)stackComponent).setColor(Optional.of(((LogicComponent)stackComponent).color().orElse(menu.color())));
        this.logicStack.set(LBRComponents.LOGIC, stackComponent);
    }

    @Override
    public <T> LogicConfigButtonReference<T> addCycleButton(Component name, Component tooltip, int x, int y, int width, int height, boolean displayOnlyValue, T initialValue, List<T> values, CycleLogicConfigButton.ValueStringifier<T> valueStringifier, Consumer<T> onChange) {
        final CycleLogicConfigButton<Object> button = new CycleLogicConfigButton<Object>(this.configX + x, this.configY + y, width, height, this.color, name, displayOnlyValue, initialValue, values, valueStringifier, (__, value) -> onChange.accept(value));
        button.setTooltip(Tooltip.create((Component)tooltip));
        this.addRenderableWidget((GuiEventListener)button);
        return new LogicConfigButtonReference<T>(this){

            @Override
            public LogicConfigButtonReference<T> setText(Component text) {
                button.setMessage(text);
                return this;
            }

            @Override
            public LogicConfigButtonReference<T> setTooltip(Component tooltip) {
                button.setTooltip(Tooltip.create((Component)tooltip));
                return this;
            }

            @Override
            public T getValue() {
                return button.value();
            }

            @Override
            public LogicConfigButtonReference<T> setValue(T value) {
                button.setValue(value);
                return this;
            }

            @Override
            public boolean isActive() {
                return button.active;
            }

            @Override
            public LogicConfigButtonReference<T> setActive(boolean active) {
                button.active = active;
                return this;
            }

            @Override
            public boolean isVisible() {
                return button.visible;
            }

            @Override
            public LogicConfigButtonReference<T> setVisible(boolean visible) {
                button.visible = visible;
                return this;
            }
        };
    }

    @Override
    public LogicConfigButtonReference<Double> addSlider(Component prefix, Component suffix, Component tooltip, int x, int y, int width, int height, double minValue, double maxValue, double currentValue, double stepSize, int precision, SliderLogicConfigButton.ValueStringifier valueStringifier, Consumer<Double> onChange) {
        final SliderLogicConfigButton button = new SliderLogicConfigButton(this.configX + x, this.configY + y, width, height, this.color, prefix, suffix, minValue, maxValue, currentValue, stepSize, precision, true, valueStringifier, (__, value) -> onChange.accept(value));
        button.setTooltip(Tooltip.create((Component)tooltip));
        this.addRenderableWidget((GuiEventListener)button);
        return new LogicConfigButtonReference<Double>(this){

            @Override
            public LogicConfigButtonReference<Double> setText(Component text) {
                button.setMessage(text);
                return this;
            }

            @Override
            public LogicConfigButtonReference<Double> setTooltip(Component tooltip) {
                button.setTooltip(Tooltip.create((Component)tooltip));
                return this;
            }

            @Override
            public Double getValue() {
                return button.getValue();
            }

            @Override
            public LogicConfigButtonReference<Double> setValue(Double value) {
                button.setValue(value);
                return this;
            }

            @Override
            public boolean isActive() {
                return button.active;
            }

            @Override
            public LogicConfigButtonReference<Double> setActive(boolean active) {
                button.active = active;
                return this;
            }

            @Override
            public boolean isVisible() {
                return button.visible;
            }

            @Override
            public LogicConfigButtonReference<Double> setVisible(boolean visible) {
                button.visible = visible;
                return this;
            }
        };
    }

    @Override
    public LogicConfigButtonReference<CheckboxState> addCheckbox(final Component text, Component tooltip, int x, int y, boolean initialValue, Consumer<Boolean> onChange) {
        IconCycleLogicConfigButton<CheckboxState> button = new IconCycleLogicConfigButton<CheckboxState>(this.configX + x, this.configY + y, this.color, LBR.id("textures/gui/slot_atlas.png"), initialValue ? CheckboxState.YES : CheckboxState.NO, Arrays.asList(CheckboxState.values()), (__, value) -> onChange.accept(value == CheckboxState.YES)){

            @Override
            protected void renderWidget(GuiGraphics internal, int mouseX, int mouseY, float partialTick) {
                super.renderWidget(internal, mouseX, mouseY, partialTick);
                TesseractGuiGraphics graphics = new TesseractGuiGraphics(internal);
                graphics.setColor(LogicConfigScreen.this.color);
                graphics.setStringDropShadow(false);
                float f = this.getX() + this.width + 6;
                float f2 = (float)this.getY() + 9.0f;
                Objects.requireNonNull(Minecraft.getInstance().font);
                graphics.drawString(text, f, f2 - 9.0f / 2.0f);
                graphics.resetColor();
            }
        };
        button.setTooltip(Tooltip.create((Component)tooltip));
        this.addRenderableWidget((GuiEventListener)button);
        return new LogicConfigButtonReference<CheckboxState>(this, button){
            final /* synthetic */ 3 val$button;
            {
                this.val$button = var2_2;
            }

            @Override
            public LogicConfigButtonReference<CheckboxState> setText(Component text) {
                return this;
            }

            @Override
            public LogicConfigButtonReference<CheckboxState> setTooltip(Component tooltip) {
                this.val$button.setTooltip(Tooltip.create((Component)tooltip));
                return this;
            }

            @Override
            public CheckboxState getValue() {
                return (CheckboxState)this.val$button.value();
            }

            @Override
            public LogicConfigButtonReference<CheckboxState> setValue(CheckboxState value) {
                this.val$button.setValue(value);
                return this;
            }

            @Override
            public boolean isActive() {
                return this.val$button.active;
            }

            @Override
            public LogicConfigButtonReference<CheckboxState> setActive(boolean active) {
                this.val$button.active = active;
                return this;
            }

            @Override
            public boolean isVisible() {
                return this.val$button.visible;
            }

            @Override
            public LogicConfigButtonReference<CheckboxState> setVisible(boolean visible) {
                this.val$button.visible = visible;
                return this;
            }
        };
    }

    @Override
    public <T extends IconCycleLogicConfigButtonIcon> LogicConfigButtonReference<T> addCycleButton(Component tooltip, int x, int y, ResourceLocation atlas, T initialValue, List<T> values, Consumer<T> onChange) {
        final IconCycleLogicConfigButton<IconCycleLogicConfigButtonIcon> button = new IconCycleLogicConfigButton<IconCycleLogicConfigButtonIcon>(this.configX + x, this.configY + y, this.color, atlas, initialValue, values, (__, value) -> onChange.accept(value));
        button.setTooltip(Tooltip.create((Component)tooltip));
        this.addRenderableWidget((GuiEventListener)button);
        return new LogicConfigButtonReference<T>(this){

            @Override
            public LogicConfigButtonReference<T> setText(Component text) {
                return this;
            }

            @Override
            public LogicConfigButtonReference<T> setTooltip(Component tooltip) {
                button.setTooltip(Tooltip.create((Component)tooltip));
                return this;
            }

            @Override
            public T getValue() {
                return button.value();
            }

            @Override
            public LogicConfigButtonReference<T> setValue(T value) {
                button.setValue(value);
                return this;
            }

            @Override
            public boolean isActive() {
                return button.active;
            }

            @Override
            public LogicConfigButtonReference<T> setActive(boolean active) {
                button.active = active;
                return this;
            }

            @Override
            public boolean isVisible() {
                return button.visible;
            }

            @Override
            public LogicConfigButtonReference<T> setVisible(boolean visible) {
                button.visible = visible;
                return this;
            }
        };
    }

    private void save() {
        new WriteLogicConfigPacket(((LogicConfigMenu)this.menu).blockPos(), this.logicEntry.slot(), this.logicEntry.component(), ((LogicConfigMenu)this.menu).returnViewPosition()).sendToServer();
    }

    private void cancel() {
        new RequestMicrochipMenuPacket(((LogicConfigMenu)this.menu).blockPos(), ((LogicConfigMenu)this.menu).returnViewPosition()).sendToServer();
    }

    protected void init() {
        super.init();
        this.configX = this.leftPos + 8 + 2;
        this.configY = this.topPos + 8 + 2;
        ((LogicConfig)this.logicEntry.component().config()).getMenuProvider().create(this, this.configWidth, this.configHeight);
        int buttonWidth = this.configWidth / 2 - 4;
        this.addRenderableWidget((GuiEventListener)new LogicConfigButton(this.configX, this.configY + this.configHeight - 16, buttonWidth, 16, this.color, (Component)LBR.text().logicConfigButtonLabelSave(), __ -> this.save()));
        this.addRenderableWidget((GuiEventListener)new LogicConfigButton(this.configX + this.configWidth - buttonWidth, this.configY + this.configHeight - 16, buttonWidth, 16, this.color, (Component)LBR.text().logicConfigButtonLabelCancel(), __ -> this.cancel()));
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(LBR.id("textures/gui/container/logic_config/background.png"), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.blit(LBR.id("textures/gui/container/logic_config/item_background.png"), this.leftPos - 61, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.pose().pushPose();
        graphics.pose().translate((float)(this.leftPos - 45), (float)(this.topPos + 18), 0.0f);
        graphics.pose().scale(2.0f, 2.0f, 1.0f);
        graphics.renderItem(this.logicStack, 0, 0);
        graphics.pose().popPose();
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && button == 0 ? this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) : super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

