/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.stickynote;

import java.util.Objects;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.tesseract.neoforge.api.Assert;

public final class StickyNoteModelData {
    public static final ModelProperty<StickyNoteModelData> KEY = new ModelProperty();
    public static final StickyNoteModelData DEFAULT = new StickyNoteModelData(DyeColor.WHITE, StickyNoteItem.getDefaultTextColor(DyeColor.WHITE), false);
    private final DyeColor color;
    private final DyeColor textColor;
    private final boolean hasText;

    public static StickyNoteModelData get(ModelData modelData) {
        StickyNoteModelData data = (StickyNoteModelData)modelData.get(KEY);
        return data != null ? data : DEFAULT;
    }

    public static StickyNoteModelData of(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof StickyNoteItem) {
            StickyNoteItem stickyNoteItem = (StickyNoteItem)item;
            StickyNote note = (StickyNote)stack.get(LBRComponents.STICKY_NOTE);
            DyeColor color = stickyNoteItem.color();
            DyeColor textColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
            return new StickyNoteModelData(color, textColor, !note.isEmpty());
        }
        throw new IllegalArgumentException("Cannot get sticky note model data of non-sticky note item stack");
    }

    public StickyNoteModelData(DyeColor color, DyeColor textColor, boolean hasText) {
        Assert.noneNull((Object[])new Object[]{color, textColor});
        this.color = color;
        this.textColor = textColor;
        this.hasText = hasText;
    }

    public DyeColor color() {
        return this.color;
    }

    public DyeColor textColor() {
        return this.textColor;
    }

    public boolean hasText() {
        return this.hasText;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.textColor, this.hasText);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof StickyNoteModelData)) return false;
        StickyNoteModelData other = (StickyNoteModelData)o;
        if (!Objects.equals(this.color, other.color)) return false;
        if (!Objects.equals(this.textColor, other.textColor)) return false;
        if (!Objects.equals(this.hasText, other.hasText)) return false;
        return true;
    }
}

