/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.little_big_redstone.LBR;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.LBRSortOrder;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.item.FloppyDiskItem;
import net.swedz.little_big_redstone.item.LogicItem;
import net.swedz.little_big_redstone.item.logicarray.LogicArrayItem;
import net.swedz.little_big_redstone.item.logicarray.LogicArrayItemHandler;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.microchip.object.logic.LogicType;
import net.swedz.little_big_redstone.microchip.object.logic.LogicTypes;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.model.BasicCustomLoaderBuilder;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;
import org.apache.commons.lang3.function.TriConsumer;

public final class LBRItems {
    public static final ItemHolder<Item> REDSTONE_BIT = LBRItems.create("redstone_bit", "Redstone Bit", Item::new, LBRSortOrder.RESOURCES).withModelBuilder(CommonModelBuilders::generated).register();
    private static final Map<DyeColor, ItemHolder<LogicArrayItem>> LOGIC_ARRAYS;
    private static final Map<DyeColor, ItemHolder<FloppyDiskItem>> FLOPPY_DISKS;
    private static final Map<DyeColor, ItemHolder<StickyNoteItem>> STICKY_NOTES;

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static ItemHolder<LogicArrayItem> logicArray(DyeColor color) {
        Assert.notNull((Object)color);
        return LOGIC_ARRAYS.get(color);
    }

    public static ItemHolder<FloppyDiskItem> floppyDisk(DyeColor color) {
        Assert.notNull((Object)color);
        return FLOPPY_DISKS.get(color);
    }

    public static ItemHolder<StickyNoteItem> stickyNote(DyeColor color) {
        Assert.notNull((Object)color);
        return STICKY_NOTES.get(color);
    }

    public static Set<ItemHolder> values() {
        return Set.copyOf(Registry.HOLDERS.values());
    }

    public static ItemHolder valueOf(String id) {
        return Registry.HOLDERS.get(id);
    }

    private static <Type extends Item> ItemHolder<Type> create(String id, String englishName, Function<Item.Properties, Type> creator, SortOrder sortOrder) {
        ItemHolder holder = new ItemHolder(LBR.id(id), englishName, Registry.ITEMS, creator).sorted(sortOrder);
        Registry.include(holder);
        return holder;
    }

    private static ItemHolder<LogicItem> createLogic(String id, String englishName, LogicType<?> type, int order) {
        return (ItemHolder)LBRItems.create(id, englishName, p -> new LogicItem((Item.Properties)p, type), LBRSortOrder.LOGIC.and((Comparable)Integer.valueOf(order))).tag(new TagKey[]{LBRTags.Items.LOGIC_COMPONENTS});
    }

    private static ItemHolder<LogicArrayItem> createLogicArray(DyeColor color, String colorEnglishName, int order) {
        String colorId = color.getName();
        String id = "%s_logic_array".formatted(colorId);
        String englishName = "%s Logic Array".formatted(colorEnglishName);
        return (ItemHolder)((ItemHolder)((ItemHolder)LBRItems.create(id, englishName, p -> new LogicArrayItem((Item.Properties)p, color), LBRSortOrder.LOGIC_ARRAYS.and((Comparable)Integer.valueOf(order))).tag(new TagKey[]{LBRTags.Items.LOGIC_ARRAYS})).withCapabilities((item, event) -> event.registerItem(Capabilities.ItemHandler.ITEM, (stack, __) -> new LogicArrayItemHandler((MutableDataComponentHolder)stack), new ItemLike[]{item}))).withModel(holder -> provider -> ((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(holder.identifier().id())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", LBR.id("item/logic_array/%s".formatted(colorId))));
    }

    private static ItemHolder<FloppyDiskItem> createFloppyDisk(DyeColor color, String colorEnglishName, int order) {
        String colorId = color.getName();
        String id = "%s_floppy_disk".formatted(colorId);
        String englishName = "%s Floppy Disk".formatted(colorEnglishName);
        return (ItemHolder)((ItemHolder)LBRItems.create(id, englishName, p -> new FloppyDiskItem((Item.Properties)p, color), LBRSortOrder.FLOPPY_DISKS.and((Comparable)Integer.valueOf(order))).tag(new TagKey[]{LBRTags.Items.FLOPPY_DISKS})).withModel(holder -> provider -> ((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(holder.identifier().id())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", LBR.id("item/floppy_disk/%s".formatted(colorId))));
    }

    private static ItemHolder<StickyNoteItem> createStickyNote(DyeColor color, String colorEnglishName, int order) {
        String colorId = color.getName();
        String id = "%s_sticky_note".formatted(colorId);
        String englishName = "%s Sticky Note".formatted(colorEnglishName);
        return (ItemHolder)((ItemHolder)LBRItems.create(id, englishName, p -> new StickyNoteItem((Item.Properties)p, color), LBRSortOrder.STICKY_NOTES.and((Comparable)Integer.valueOf(order))).tag(new TagKey[]{LBRTags.Items.STICKY_NOTES})).withModel(holder -> provider -> ((ItemModelBuilder)((ItemModelBuilder)((BasicCustomLoaderBuilder)((ItemModelBuilder)((ItemModelBuilder)provider.getBuilder(holder.identifier().id())).parent((ModelFile)new ModelFile.UncheckedModelFile(LBR.id("item/sticky_note")))).customLoader((parent, efh) -> new BasicCustomLoaderBuilder(LBR.id("sticky_note_item"), (ModelBuilder)parent, efh))).end()).texture("layer0", LBR.id("item/sticky_note/%s".formatted(colorId)))).texture("layer1", LBR.id("item/sticky_note/text")));
    }

    static {
        int index2 = 0;
        for (LogicType<?> type : LogicTypes.values()) {
            LBRItems.createLogic(type.id(), type.englishName(), type, index2++).register();
        }
        HashMap logicArrays = Maps.newHashMap();
        HashMap floppyDisks = Maps.newHashMap();
        HashMap stickyNotes = Maps.newHashMap();
        LBRColors.forEachIndexed((TriConsumer<DyeColor, String, Integer>)((TriConsumer)(color, colorName, index) -> {
            logicArrays.put(color, LBRItems.createLogicArray(color, colorName, index).register());
            floppyDisks.put(color, LBRItems.createFloppyDisk(color, colorName, index).register());
            stickyNotes.put(color, LBRItems.createStickyNote(color, colorName, index).register());
        }));
        LOGIC_ARRAYS = Collections.unmodifiableMap(logicArrays);
        FLOPPY_DISKS = Collections.unmodifiableMap(floppyDisks);
        STICKY_NOTES = Collections.unmodifiableMap(stickyNotes);
    }

    public static final class Registry {
        public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"little_big_redstone");
        private static final Map<String, ItemHolder> HOLDERS = Maps.newHashMap();

        private static void init(IEventBus bus) {
            ITEMS.register(bus);
        }

        public static void include(ItemHolder holder) {
            HOLDERS.put(holder.identifier().id(), holder);
        }
    }
}

