/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.item.tooltip;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.swedz.little_big_redstone.LBR;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.guigraphics.TesseractGuiGraphics;

public final class ItemContainerContentsClientTooltip
implements ClientTooltipComponent {
    private final ItemContainerContents storage;
    private final int maxColumns;
    private final int maxRows;
    private final boolean showExtraSlot;

    public ItemContainerContentsClientTooltip(ItemContainerContents storage, int maxColumns, int maxRows, boolean showExtraSlot) {
        Assert.that((maxColumns > 0 ? 1 : 0) != 0, (String)"Must have at least one column.");
        this.storage = storage;
        this.maxColumns = maxColumns;
        this.maxRows = maxRows;
        this.showExtraSlot = showExtraSlot;
    }

    public int getHeight() {
        return this.storage.getSlots() == 0 ? 0 : this.backgroundHeight() + 4;
    }

    public int getWidth(Font font) {
        return this.storage.getSlots() == 0 ? 0 : this.backgroundWidth();
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 18 + 3;
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int gridSizeX() {
        return Math.min(this.maxColumns, this.storage.getSlots() + (this.showExtraSlot ? 1 : 0));
    }

    private int gridSizeY() {
        int sizeY = this.storage.getSlots() == 0 ? 0 : (int)Math.ceil(((double)this.storage.getSlots() + (double)(this.showExtraSlot ? 1 : 0)) / (double)this.gridSizeX());
        return this.maxRows > 0 ? Math.min(this.maxRows, sizeY) : sizeY;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics vanilla) {
        TesseractGuiGraphics graphics = new TesseractGuiGraphics(vanilla);
        if (this.storage.getSlots() != 0) {
            graphics.setTexture(LBR.id("textures/gui/slot_background.png"));
            graphics.nineSlice(x, y, this.backgroundWidth(), this.backgroundHeight(), 32, 32, 4);
        }
        int index = 0;
        for (int gridY = 0; gridY < this.gridSizeY(); ++gridY) {
            for (int gridX = 0; gridX < this.gridSizeX(); ++gridX) {
                int posX = x + gridX * 18 + 1;
                int posY = y + gridY * 18 + 1;
                this.renderSlot(graphics, font, posX, posY, index++);
            }
        }
    }

    private void renderSlot(TesseractGuiGraphics graphics, Font font, int x, int y, int itemIndex) {
        graphics.setTexture(LBR.id("textures/gui/slot_atlas.png"));
        graphics.blit(x, y, 0, 0, 18, 18);
        if (itemIndex < this.storage.getSlots()) {
            ItemStack stack = this.storage.getStackInSlot(itemIndex);
            graphics.renderItem(stack, x + 1, y + 1, itemIndex);
            graphics.renderItemDecorations(stack, x + 1, y + 1);
        }
    }
}

