/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.gui.stickynote.reference;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.swedz.little_big_redstone.LBRComponents;
import net.swedz.little_big_redstone.LBRTags;
import net.swedz.little_big_redstone.gui.stickynote.reference.StickyNoteReference;
import net.swedz.little_big_redstone.item.stickynote.StickyNote;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.little_big_redstone.network.packet.StickyNotePacket;

public final class HeldItemStickyNoteReference
implements StickyNoteReference {
    private final InteractionHand hand;
    private final DyeColor color;
    private final DyeColor textColor;
    private final String text;

    public HeldItemStickyNoteReference(InteractionHand hand, ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof StickyNoteItem)) {
            throw new IllegalArgumentException("Non-sticky note item supplied");
        }
        StickyNoteItem item2 = (StickyNoteItem)item;
        this.hand = hand;
        this.color = item2.color();
        this.textColor = (DyeColor)stack.get(LBRComponents.STICKY_NOTE_TEXT_COLOR);
        this.text = ((StickyNote)stack.getOrDefault(LBRComponents.STICKY_NOTE, (Object)StickyNote.EMPTY)).text();
    }

    private HeldItemStickyNoteReference(InteractionHand hand, DyeColor color, DyeColor textColor, String text) {
        this.hand = hand;
        this.color = color;
        this.textColor = textColor;
        this.text = text;
    }

    @Override
    public DyeColor color() {
        return this.color;
    }

    @Override
    public DyeColor textColor() {
        return this.textColor;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public StickyNoteReference withText(String text) {
        return new HeldItemStickyNoteReference(this.hand, this.color, this.textColor, text);
    }

    @Override
    public void saveClient(Level level, Player player) {
        new StickyNotePacket(StickyNotePacket.ReferenceType.HELD_ITEM, this.hand.ordinal(), StickyNotePacket.Action.DONE_EDIT, this.text).sendToServer();
    }

    @Override
    public void saveServer(Level level, Player player) {
        ItemStack stack = player.getItemInHand(this.hand);
        Item item = stack.getItem();
        if (item instanceof StickyNoteItem) {
            StickyNoteItem item2 = (StickyNoteItem)item;
            stack.set(LBRComponents.STICKY_NOTE, (Object)new StickyNote(this.text));
        }
    }

    @Override
    public boolean isStillValid(Level level, Player player) {
        return player.getItemInHand(this.hand).is(LBRTags.Items.STICKY_NOTES);
    }
}

