/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.model.stickynote.item;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import net.swedz.little_big_redstone.LBRColors;
import net.swedz.little_big_redstone.client.model.stickynote.StickyNoteModelData;

public final class StickyNoteItemBakedModel
implements IDynamicBakedModel {
    private static final RenderTypeGroup RENDER_TYPES = new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
    private final ItemTransforms transforms;
    private final boolean useAmbientOcclusion;
    private final boolean isGui3d;
    private final boolean usesBlockLight;
    private final ModelState modelState;
    private final TextureAtlasSprite particle;
    private final List<TextureAtlasSprite> layers;

    StickyNoteItemBakedModel(ItemTransforms transforms, boolean useAmbientOcclusion, boolean isGui3d, boolean usesBlockLight, ModelState modelState, TextureAtlasSprite particle, List<TextureAtlasSprite> layers) {
        this.transforms = transforms;
        this.useAmbientOcclusion = useAmbientOcclusion;
        this.isGui3d = isGui3d;
        this.usesBlockLight = usesBlockLight;
        this.modelState = modelState;
        this.particle = particle;
        this.layers = layers;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction direction, RandomSource random, ModelData modelData, RenderType renderType) {
        StickyNoteModelData data = StickyNoteModelData.get(modelData);
        ArrayList quads = Lists.newArrayList();
        for (int index = 0; index < this.layers.size(); ++index) {
            TextureAtlasSprite layer = this.layers.get(index);
            ExtraFaceData faceData = index == 0 ? null : new ExtraFaceData(LBRColors.stickyNoteText(data.textColor()), ExtraFaceData.DEFAULT.blockLight(), ExtraFaceData.DEFAULT.skyLight(), ExtraFaceData.DEFAULT.ambientOcclusion());
            CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder((boolean)this.useAmbientOcclusion, (boolean)this.isGui3d, (boolean)this.usesBlockLight, (TextureAtlasSprite)this.particle, (ItemOverrides)this.getOverrides(), (ItemTransforms)this.transforms);
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)index, (TextureAtlasSprite)layer, (ExtraFaceData)faceData);
            List layerQuads = UnbakedGeometryHelper.bakeElements((List)unbaked, __ -> layer, (ModelState)this.modelState);
            quads.addAll(layerQuads);
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return this.useAmbientOcclusion;
    }

    public boolean isGui3d() {
        return this.isGui3d;
    }

    public boolean usesBlockLight() {
        return this.usesBlockLight;
    }

    public boolean isCustomRenderer() {
        return true;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particle;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.CUTOUT});
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        super.applyTransform(transformType, poseStack, applyLeftHandTransform);
        this.transforms.getTransform(transformType).apply(applyLeftHandTransform, poseStack);
        return this;
    }
}

