/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.little_big_redstone.client.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.swedz.little_big_redstone.LBRItemDisplayContext;
import net.swedz.little_big_redstone.client.model.MicrochipGuiContextModelData;
import net.swedz.little_big_redstone.client.model.stickynote.StickyNoteModelData;
import net.swedz.little_big_redstone.item.stickynote.StickyNoteItem;
import net.swedz.tesseract.neoforge.helper.model.QuadColorFix;

public final class StickyNoteItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final RandomSource random = RandomSource.create();
    private final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    public StickyNoteItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (!(item instanceof StickyNoteItem)) {
            return;
        }
        StickyNoteItem stickyNoteItem = (StickyNoteItem)item;
        ModelData modelData = ModelData.builder().with(StickyNoteModelData.KEY, (Object)StickyNoteModelData.of(stack)).with(MicrochipGuiContextModelData.KEY, (Object)new MicrochipGuiContextModelData(displayContext == LBRItemDisplayContext.MICROCHIP_GUI)).build();
        BakedModel model = this.itemRenderer.getModel(stack, null, null, 0);
        VertexConsumer buffer = bufferSource.getBuffer(NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        for (BakedQuad quad : model.getQuads(null, null, this.random, modelData, null)) {
            QuadColorFix.putBulkData((VertexConsumer)buffer, (PoseStack.Pose)poseStack.last(), (BakedQuad)quad, (int)packedLight, (int)packedOverlay);
        }
    }
}

