/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.Lithostitched;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class UnboundReferenceProcessor
extends StructureProcessor {
    public static final MapCodec<UnboundReferenceProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.PROCESSOR_LIST).fieldOf("name").forGetter(UnboundReferenceProcessor::name)).apply((Applicative)instance, UnboundReferenceProcessor::new));
    public static final StructureProcessorType<UnboundReferenceProcessor> TYPE = () -> CODEC;
    private final ResourceKey<StructureProcessorList> name;

    private UnboundReferenceProcessor(ResourceKey<StructureProcessorList> name) {
        this.name = name;
    }

    public static UnboundReferenceProcessor of(String name) {
        return new UnboundReferenceProcessor(UnboundReferenceProcessor.key(Lithostitched.id(name)));
    }

    private static ResourceKey<StructureProcessorList> key(ResourceLocation identifier) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)identifier);
    }

    public ResourceKey<StructureProcessorList> name() {
        return this.name;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        StructureTemplate.StructureBlockInfo processedBlock = absolute;
        Registry registry = Lithostitched.registry(levelReader.registryAccess(), Registries.PROCESSOR_LIST);
        Optional list = registry.getOptional(this.name);
        if (list.isPresent()) {
            for (StructureProcessor processor : ((StructureProcessorList)list.get()).list()) {
                processedBlock = processor.processBlock(levelReader, pos, pivot, relative, processedBlock, settings);
                if (processedBlock != null) continue;
                return null;
            }
        }
        return processedBlock;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return TYPE;
    }
}

