/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.processor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.processor.RandomSettings;
import dev.worldgen.lithostitched.worldgen.processor.condition.ProcessorCondition;
import dev.worldgen.lithostitched.worldgen.processor.enums.RandomMode;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class ConditionProcessor
extends StructureProcessor {
    private static final Codec<List<StructureProcessor>> PROCESSOR_CODEC = LithostitchedCodecs.compactList(StructureProcessorType.SINGLE_CODEC);
    public static final MapCodec<ConditionProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RandomSettings.CODEC.fieldOf("random_mode").orElse((Object)new RandomSettings(RandomMode.PER_BLOCK)).forGetter(ConditionProcessor::randomSettings), (App)ProcessorCondition.CODEC.fieldOf("if_true").forGetter(ConditionProcessor::condition), (App)PROCESSOR_CODEC.fieldOf("then").forGetter(ConditionProcessor::thenRun), (App)PROCESSOR_CODEC.fieldOf("else").orElse(List.of()).forGetter(ConditionProcessor::elseRun)).apply((Applicative)instance, ConditionProcessor::new));
    public static final StructureProcessorType<ConditionProcessor> TYPE = () -> CODEC;
    private final RandomSettings randomSettings;
    private final ProcessorCondition condition;
    private final List<StructureProcessor> thenRun;
    private final List<StructureProcessor> elseRun;

    public ConditionProcessor(RandomSettings randomSettings, ProcessorCondition condition, List<StructureProcessor> thenRun, List<StructureProcessor> elseRun) {
        this.randomSettings = randomSettings;
        this.condition = condition;
        this.thenRun = thenRun;
        this.elseRun = elseRun;
    }

    public RandomSettings randomSettings() {
        return this.randomSettings;
    }

    public ProcessorCondition condition() {
        return this.condition;
    }

    private List<StructureProcessor> thenRun() {
        return this.thenRun;
    }

    private List<StructureProcessor> elseRun() {
        return this.elseRun;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos pivot, StructureTemplate.StructureBlockInfo relative, StructureTemplate.StructureBlockInfo absolute, StructurePlaceSettings settings) {
        if (levelReader instanceof WorldGenLevel) {
            StructureProcessor processor;
            WorldGenLevel level = (WorldGenLevel)levelReader;
            RandomSource random = this.randomSettings.create(level, pos, absolute);
            StructureTemplate.StructureBlockInfo newInput = new StructureTemplate.StructureBlockInfo(relative.pos(), absolute.state(), absolute.nbt());
            StructureTemplate.StructureBlockInfo newLocation = new StructureTemplate.StructureBlockInfo(absolute.pos(), level.getBlockState(absolute.pos()), absolute.nbt());
            boolean passed = this.condition.test(level, new ProcessorCondition.Data(pos, pivot, newInput, newLocation), settings, random);
            StructureTemplate.StructureBlockInfo processedBlock = absolute;
            Iterator<StructureProcessor> iterator = (passed ? this.thenRun : this.elseRun).iterator();
            while (iterator.hasNext() && (processedBlock = (processor = iterator.next()).processBlock(levelReader, pos, pivot, relative, processedBlock, settings)) != null) {
            }
            return processedBlock;
        }
        return absolute;
    }

    protected StructureProcessorType<?> getType() {
        return TYPE;
    }
}

