/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.util.weighted.Weighted;
import dev.worldgen.lithostitched.util.weighted.WeightedList;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public record VinesConfig(WeightedList<Block> blocks, Optional<HolderSet<Block>> canPlaceOn, IntProvider maxLength) implements FeatureConfiguration
{
    private static final WeightedList<Block> DEFAULT_BLOCK = WeightedList.builder().add(Blocks.VINE).build();
    public static final Codec<VinesConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LithostitchedCodecs.compactWeightedList(BuiltInRegistries.BLOCK.byNameCodec(), false).fieldOf("block").orElse(DEFAULT_BLOCK).forGetter(VinesConfig::blocks), (App)LithostitchedCodecs.BLOCK_SET.optionalFieldOf("can_place_on").forGetter(VinesConfig::canPlaceOn), (App)IntProvider.codec((int)1, (int)256).fieldOf("max_length").orElse((Object)ConstantInt.of((int)1)).forGetter(VinesConfig::maxLength)).apply((Applicative)instance, VinesConfig::new)).validate(VinesConfig::validate);

    private DataResult<VinesConfig> validate() {
        if (this.blocks.unwrap().stream().map(Weighted::value).anyMatch(block -> !(block instanceof VineBlock))) {
            return DataResult.error(() -> "State should be a vine block");
        }
        return DataResult.success((Object)this);
    }

    public boolean canPlaceOn(BlockState state) {
        return this.canPlaceOn.isEmpty() || state.is(this.canPlaceOn.get());
    }
}

