/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.blockpredicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.apache.commons.lang3.mutable.MutableBoolean;

public record InStructurePredicate(Optional<Holder<Structure>> structure, SearchRange searchRange) implements BlockPredicate
{
    public static final MapCodec<InStructurePredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.CODEC.optionalFieldOf("structure").forGetter(InStructurePredicate::structure), (App)SearchRange.CODEC.fieldOf("search_range").forGetter(InStructurePredicate::searchRange)).apply((Applicative)instance, InStructurePredicate::new));
    public static final BlockPredicateType<InStructurePredicate> TYPE = () -> CODEC;

    public BlockPredicateType<?> type() {
        return TYPE;
    }

    public boolean test(WorldGenLevel worldGenLevel, BlockPos pos) {
        BoundingBox adjustedBox = this.searchRange.box().moved(pos.getX(), pos.getY(), pos.getZ());
        ServerLevel level = worldGenLevel.getLevel();
        StructureManager manager = level.structureManager();
        HashMap references = new HashMap();
        adjustedBox.intersectingChunks().forEach(chunk -> references.putAll(level.getChunk(chunk.x, chunk.z, ChunkStatus.STRUCTURE_REFERENCES).getAllReferences()));
        for (Map.Entry reference : references.entrySet()) {
            if (this.structure.isPresent() && !((Structure)this.structure.get().value()).equals(reference.getKey())) continue;
            Predicate<StructureStart> predicate = start -> {
                for (StructurePiece piece : start.getPieces()) {
                    if (!piece.getBoundingBox().intersects(adjustedBox)) continue;
                    return true;
                }
                return false;
            };
            MutableBoolean overlappingBox = new MutableBoolean(false);
            manager.fillStartsForStructure((Structure)reference.getKey(), (LongSet)reference.getValue(), start -> {
                if (overlappingBox.isFalse() && predicate.test((StructureStart)start)) {
                    overlappingBox.setTrue();
                }
            });
            if (!overlappingBox.isTrue()) continue;
            return true;
        }
        return false;
    }

    public record SearchRange(int horizontal, int vertical) {
        private static final Codec<Integer> BASE_CODEC = Codec.intRange((int)0, (int)32);
        private static final Codec<SearchRange> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BASE_CODEC.fieldOf("horizontal").forGetter(SearchRange::horizontal), (App)ExtraCodecs.intRange((int)0, (int)DimensionType.Y_SIZE).optionalFieldOf("vertical", (Object)DimensionType.Y_SIZE).forGetter(SearchRange::vertical)).apply((Applicative)instance, SearchRange::new));
        public static final Codec<SearchRange> CODEC = Codec.either(FULL_CODEC, BASE_CODEC).xmap(either -> (SearchRange)either.map(Function.identity(), SearchRange::new), maxDistance -> maxDistance.horizontal == maxDistance.vertical ? Either.right((Object)maxDistance.horizontal) : Either.left((Object)maxDistance));

        public SearchRange(int value) {
            this(value, value);
        }

        public BoundingBox box() {
            return new BoundingBox(-this.horizontal, -this.vertical, -this.horizontal, this.horizontal, this.vertical, this.horizontal);
        }
    }
}

