/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.google.common.base.Suppliers;
import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.mixin.common.ChunkGeneratorAccessor;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.dimension.LevelStem;

public class ModifierManager {
    public static void applyModifiers(MinecraftServer server) {
        boolean fabricFeaturesModified = false;
        RegistryAccess.Frozen registries = server.registryAccess();
        HolderLookup.RegistryLookup modifiers = registries.lookupOrThrow(LithostitchedRegistryKeys.WORLDGEN_MODIFIER);
        for (Holder.Reference<Modifier> reference : ModifierManager.sortByPriority(modifiers.listElements())) {
            Lithostitched.debug("Applying modifier with id: {}", reference.key().location());
            ((Modifier)reference.value()).applyModifier((RegistryAccess)registries);
            if (!((Modifier)reference.value()).internal$modifiesFabricFeatures()) continue;
            fabricFeaturesModified = true;
        }
        if (fabricFeaturesModified) {
            for (LevelStem dimension : Lithostitched.registry((RegistryAccess)registries, Registries.LEVEL_STEM).stream().toList()) {
                ChunkGeneratorAccessor accessor = (ChunkGeneratorAccessor)dimension.generator();
                BiomeSource source = accessor.getBiomeSource();
                accessor.setFeaturesPerStep((Supplier<List<FeatureSorter.StepFeatureData>>)Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(source.possibleBiomes()), biome -> accessor.getGetter().apply((Holder<Biome>)biome).features(), (boolean)true)));
            }
        }
    }

    static List<Holder.Reference<Modifier>> sortByPriority(Stream<Holder.Reference<Modifier>> modifiers) {
        return modifiers.sorted(Comparator.comparingInt(reference -> ((Modifier)reference.value()).priority())).toList();
    }
}

