/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.worldgen.feature.config.WellConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class WellFeature
extends Feature<WellConfig> {
    public static final WellFeature FEATURE = new WellFeature();

    public WellFeature() {
        super(WellConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<WellConfig> context) {
        BlockPos pos;
        int z;
        int x;
        WorldGenLevel world = context.level();
        BlockPos origin = context.origin();
        WellConfig config = (WellConfig)context.config();
        RandomSource random = context.random();
        for (x = -2; x <= 2; ++x) {
            for (z = -2; z <= 2; ++z) {
                if (!world.isEmptyBlock(origin.offset(x, -1, z)) || !world.isEmptyBlock(origin.offset(x, -2, z))) continue;
                return false;
            }
        }
        for (x = -2; x <= 2; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (z = -2; z <= 2; ++z) {
                    boolean axisAligned;
                    pos = origin.offset(x, y, z);
                    boolean outer = Math.abs(x) == 2 || Math.abs(z) == 2;
                    boolean middle = Math.abs(x) == 1 && Math.abs(z) == 1;
                    boolean inner = x == 0 && z == 0;
                    boolean bl = axisAligned = x == 0 || z == 0;
                    Object blockProvider = y == -3 ? config.standardProvider() : (y < 0 ? (axisAligned && !outer ? (y == -2 ? config.groundProvider() : config.fluidProvider()) : config.standardProvider()) : (outer ? (y > 0 ? BlockStateProvider.simple((Block)Blocks.AIR) : (axisAligned ? config.slabProvider() : config.standardProvider())) : (middle && y != 3 ? config.standardProvider() : (y == 3 ? (inner ? config.standardProvider() : config.slabProvider()) : BlockStateProvider.simple((Block)Blocks.AIR)))));
                    world.setBlock(pos, blockProvider.getState(random, pos), 2);
                }
            }
        }
        for (int i = 0; i < config.suspiciousPlacements().sample(random); ++i) {
            for (int offset = 0; offset < 2; ++offset) {
                pos = origin.below(offset + 2).relative(Direction.Plane.HORIZONTAL.getRandomDirection(random));
                world.setBlock(pos, config.suspiciousProvider().getState(random, pos), 2);
                Optional susBlock = world.getBlockEntity(pos, BlockEntityType.BRUSHABLE_BLOCK);
                if (!susBlock.isPresent()) continue;
                ((BrushableBlockEntity)susBlock.get()).setLootTable(config.suspiciousLootTable(), pos.asLong());
            }
        }
        return true;
    }
}

