/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.feature;

import dev.worldgen.lithostitched.Lithostitched;
import dev.worldgen.lithostitched.worldgen.feature.config.DungeonConfig;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class DungeonFeature
extends Feature<DungeonConfig> {
    public static final DungeonFeature FEATURE = new DungeonFeature();

    public DungeonFeature() {
        super(DungeonConfig.CODEC);
    }

    public boolean place(FeaturePlaceContext<DungeonConfig> context) {
        BlockPos currentPos;
        int z;
        int y;
        int x;
        BlockPos startPos = context.origin();
        RandomSource random = context.random();
        WorldGenLevel world = context.level();
        DungeonConfig config = (DungeonConfig)context.config();
        Predicate<BlockState> predicate = config.dungeonInvalidBlocks().map(set -> state -> state.is(set)).orElse(state -> state.is(BlockTags.FEATURES_CANNOT_REPLACE));
        int xRadius = config.radius().sample(random);
        int minX = -xRadius - 1;
        int maxX = xRadius + 1;
        int zRadius = config.radius().sample(random);
        int minZ = -zRadius - 1;
        int maxZ = zRadius + 1;
        int openings = 0;
        for (x = minX; x <= maxX; ++x) {
            for (y = -1; y <= 4; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    currentPos = startPos.offset(x, y, z);
                    boolean bl = world.getBlockState(currentPos).isSolid();
                    if (y == -1 && !bl) {
                        return false;
                    }
                    if (y == 4 && !bl) {
                        return false;
                    }
                    if (x != minX && x != maxX && z != minZ && z != maxZ || y != 0 || !world.isEmptyBlock(currentPos) || !world.isEmptyBlock(currentPos.above())) continue;
                    ++openings;
                }
            }
        }
        if (openings >= config.minOpenings() && openings <= config.maxOpenings()) {
            for (x = minX; x <= maxX; ++x) {
                for (y = 3; y >= -1; --y) {
                    for (z = minZ; z <= maxZ; ++z) {
                        currentPos = startPos.offset(x, y, z);
                        BlockState currentState = world.getBlockState(currentPos);
                        if (x != minX && y != -1 && z != minZ && x != maxX && y != 4 && z != maxZ) {
                            if (currentState.is(Blocks.CHEST) || currentState.is(Blocks.SPAWNER)) continue;
                            this.safeSetBlock(world, currentPos, Blocks.CAVE_AIR.defaultBlockState(), predicate);
                            continue;
                        }
                        if (currentPos.getY() >= context.chunkGenerator().getMinY() && !world.getBlockState(currentPos.below()).isSolid()) {
                            world.setBlock(currentPos, Blocks.CAVE_AIR.defaultBlockState(), 2);
                            continue;
                        }
                        if (!currentState.isSolid() || currentState.is(Blocks.CHEST)) continue;
                        this.safeSetBlock(world, currentPos, y == -1 ? config.floorProvider().getState(random, currentPos) : config.wallProvider().getState(random, currentPos), predicate);
                    }
                }
            }
            block6: for (x = 0; x < config.maxChests(); ++x) {
                for (y = 0; y < 3; ++y) {
                    int w;
                    int v;
                    z = startPos.getX() + random.nextInt(xRadius * 2 + 1) - xRadius;
                    BlockPos chestPos = new BlockPos(z, v = startPos.getY(), w = startPos.getZ() + random.nextInt(zRadius * 2 + 1) - zRadius);
                    if (!world.isEmptyBlock(chestPos)) continue;
                    int solidFaces = 0;
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        if (!world.getBlockState(chestPos.relative(direction)).isSolid()) continue;
                        ++solidFaces;
                    }
                    if (solidFaces != true) continue;
                    this.safeSetBlock(world, chestPos, StructurePiece.reorient((BlockGetter)world, (BlockPos)chestPos, (BlockState)Blocks.CHEST.defaultBlockState()), predicate);
                    Optional chestEntity = world.getBlockEntity(chestPos, BlockEntityType.CHEST);
                    chestEntity.ifPresent(chestBlockEntity -> chestBlockEntity.setLootTable(config.lootTable(), random.nextLong()));
                    continue block6;
                }
            }
            this.safeSetBlock(world, startPos, Blocks.SPAWNER.defaultBlockState(), predicate);
            BlockEntity blockEntity = world.getBlockEntity(startPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                spawner.setEntityId(config.spawnerMobs().getRandom(random).orElse(EntityType.PIG), random);
            } else {
                Lithostitched.LOGGER.error(String.format("Failed to get spawner block entity for dungeon at block position (%s)", startPos));
            }
            return true;
        }
        return false;
    }
}

