/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.ui;

import dev.schmarrn.lighty.Renderers;
import dev.schmarrn.lighty.event.KeyBind;
import dev.schmarrn.lighty.overlaystate.SMACH;
import dev.schmarrn.lighty.ui.ModeSelectionScreen;
import dev.schmarrn.lighty.ui.SettingsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class LightyScreen
extends Screen {
    private final Screen parent;
    private final boolean isInModMenu;

    public LightyScreen(Screen parent) {
        super((Component)Component.translatable((String)"modeSwitcher.lighty.title"));
        this.parent = parent;
        this.isInModMenu = false;
    }

    public LightyScreen(Screen parent, boolean isInModMenu) {
        super((Component)Component.translatable((String)"modeSwitcher.lighty.title"));
        this.parent = parent;
        this.isInModMenu = isInModMenu;
    }

    protected void init() {
        GridLayout gridWidget = new GridLayout();
        gridWidget.defaultCellSetting().paddingBottom(4).alignHorizontallyCenter().alignVerticallyMiddle();
        GridLayout.RowHelper adder = gridWidget.createRowHelper(1);
        if (!this.isInModMenu) {
            adder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"lighty.overlay", (Object[])new Object[]{CommonComponents.optionStatus((boolean)SMACH.isEnabled()).getString()}), btn -> {
                SMACH.toggle();
                btn.setMessage((Component)Component.translatable((String)"lighty.overlay", (Object[])new Object[]{CommonComponents.optionStatus((boolean)SMACH.isEnabled()).getString()}));
            }).tooltip(Tooltip.create((Component)Component.translatable((String)"lighty.overlay.tooltip", (Object[])new Object[]{KeyBind.toggleKeyBind.getTranslatedKeyMessage().getString()}))).build());
        }
        adder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"lighty.selected", (Object[])new Object[]{Component.translatable((String)("modeSwitcher." + Renderers.getRenderer().getResourceLocation().toString().replace(":", ".")))}), button -> Minecraft.getInstance().setScreen((Screen)new ModeSelectionScreen(this))).tooltip(Tooltip.create((Component)Component.translatable((String)"lighty.selected.tooltip"))).build());
        adder.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"modeSwitcher.lighty.settings"), button -> Minecraft.getInstance().setScreen((Screen)new SettingsScreen(this))).tooltip(Tooltip.create((Component)Component.translatable((String)"modeSwitcher.lighty.settings.tooltip"))).build());
        adder.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).build(), adder.newCellSettings().paddingTop(6));
        gridWidget.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)gridWidget, (int)0, (int)(this.height / 6 - 12), (int)this.width, (int)this.height, (float)0.5f, (float)0.0f);
        gridWidget.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

