/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class NumberRenderer
implements OverlayRenderer {
    private static final float PXL = 0.0625f;
    private static final float dx = 0.25f;
    private static final float dz = 0.25f;

    private static void renderDigit(BufferBuilder builder, int digit, float x, float y, float z, int color, int lightmap) {
        float startU = (float)(3 & digit) / 4.0f;
        float startV = (float)(digit >> 2 & 3) / 4.0f;
        builder.addVertex(x, y, z).setColor(color).setUv(startU, startV).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x, y, z + 0.25f).setColor(color).setUv(startU, startV + 0.25f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x + 0.25f, y, z + 0.25f).setColor(color).setUv(startU + 0.25f, startV + 0.25f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x + 0.25f, y, z).setColor(color).setUv(startU + 0.25f, startV).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
    }

    private static void renderNumber(BufferBuilder builder, int number, float x, float y, float z, int color, int lightmap) {
        int oneDigit = number % 10;
        int tenDigit = number / 10;
        if (tenDigit > 0) {
            NumberRenderer.renderDigit(builder, tenDigit, x, y, z, color, lightmap);
            NumberRenderer.renderDigit(builder, oneDigit, x + 0.25f - 0.0625f, y, z, color, lightmap);
        } else {
            NumberRenderer.renderDigit(builder, oneDigit, x + 0.09375f, y, z, color, lightmap);
        }
    }

    @Override
    public void build(ClientLevel level, BlockPos pos, OverlayData data, BufferBuilder builder, int lightmap) {
        float x1 = (float)data.rPos().getX() + 0.328125f;
        float y = (float)data.rPos().getY() + 1.0f + 0.005f + data.yOffset();
        float z1 = (float)data.rPos().getZ() + 0.25f;
        if (((Boolean)Config.SHOW_SKYLIGHT_LEVEL.getValue()).booleanValue()) {
            NumberRenderer.renderNumber(builder, data.blockNumber(), x1, y, z1, data.color(), lightmap);
            NumberRenderer.renderNumber(builder, data.skyNumber(), x1, y, z1 + 0.375f, data.color(), lightmap);
        } else {
            NumberRenderer.renderNumber(builder, data.blockNumber(), x1, y, z1 + 0.125f, data.color(), lightmap);
        }
    }

    @Override
    public void beforeRendering() {
        RenderType.cutout().setupRenderState();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"textures/block/numbers.png"));
    }

    @Override
    public void afterRendering() {
        RenderType.cutout().clearRenderState();
        RenderSystem.disableDepthTest();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"renderer_number");
    }

    public static void init() {
        NumberRenderer dp = new NumberRenderer();
        ModeManager.registerRenderer(dp.getResourceLocation(), dp);
    }
}

