/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class CrossRenderer
implements OverlayRenderer {
    @Override
    public void build(ClientLevel level, BlockPos pos, OverlayData data, BufferBuilder builder, int lightmap) {
        float x1 = data.rPos().getX();
        float x2 = (float)data.rPos().getX() + 1.0f;
        float y = (float)data.rPos().getY() + 1.005f + data.yOffset();
        float z1 = data.rPos().getZ();
        float z2 = (float)data.rPos().getZ() + 1.0f;
        builder.addVertex(x1, y, z1).setColor(data.color()).setUv(0.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x1, y, z2).setColor(data.color()).setUv(0.0f, 1.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x2, y, z2).setColor(data.color()).setUv(1.0f, 1.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
        builder.addVertex(x2, y, z1).setColor(data.color()).setUv(1.0f, 0.0f).setLight(lightmap).setNormal(0.0f, 1.0f, 0.0f);
    }

    @Override
    public void beforeRendering() {
        RenderType.cutout().setupRenderState();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)((ResourceLocation)Config.CROSS_TEXTURE.getValue()));
        RenderSystem.enableDepthTest();
    }

    @Override
    public void afterRendering() {
        RenderSystem.disableDepthTest();
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"renderer_cross");
    }

    public static void init() {
        CrossRenderer dp = new CrossRenderer();
        ModeManager.registerRenderer(dp.getResourceLocation(), dp);
    }
}

