/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import dev.schmarrn.lighty.DataProviders;
import dev.schmarrn.lighty.Renderers;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.api.OverlayRenderer;
import dev.schmarrn.lighty.compat.IrisCompat;
import dev.schmarrn.lighty.config.Config;
import dev.schmarrn.lighty.event.BufferHolder;
import dev.schmarrn.lighty.overlaystate.SMACH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class Compute {
    private static final int INITIAL_HASHSET_CAPACITY = 550;
    private static HashSet<SectionPos> toBeUpdated = new HashSet(550);
    private static HashSet<SectionPos> toBeRemoved = new HashSet(550);
    private static final Map<SectionPos, BufferHolder> cachedBuffers = new HashMap<SectionPos, BufferHolder>();
    private static ChunkPos playerPos = null;
    private static int computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)Minecraft.getInstance().options.renderDistance().get());

    private static boolean outOfRange(SectionPos pos) {
        int computationDistanceSquared = computationDistance * computationDistance;
        if (playerPos == null) {
            return true;
        }
        int sqX = (pos.x() - Compute.playerPos.x) * (pos.x() - Compute.playerPos.x);
        int sqZ = (pos.z() - Compute.playerPos.z) * (pos.z() - Compute.playerPos.z);
        return sqX > computationDistanceSquared || sqZ > computationDistanceSquared;
    }

    public static void clear() {
        toBeUpdated = new HashSet(550);
        cachedBuffers.forEach((sectionPos, vertexBuffer) -> vertexBuffer.close());
        cachedBuffers.clear();
        computationDistance = Math.min((Integer)Config.OVERLAY_DISTANCE.getValue(), (Integer)Minecraft.getInstance().options.renderDistance().get());
    }

    public static void updateBlockPos(BlockPos pos) {
        SectionPos spos = SectionPos.of((BlockPos)pos);
        if (spos.minBlockY() == pos.getY()) {
            Compute.updateSubChunk(spos.offset(0, -1, 0));
        }
        Compute.updateSubChunk(spos);
    }

    public static void updateSubChunk(SectionPos pos) {
        if (Compute.outOfRange(pos)) {
            return;
        }
        toBeUpdated.add(pos);
    }

    private static BufferHolder buildChunk(OverlayRenderer renderer, List<OverlayDataProvider> dataProviders, SectionPos chunkPos, Tesselator tesselator, ClientLevel world) {
        ArrayList<OverlayData> overlayData = new ArrayList<OverlayData>();
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    BlockPos pos = chunkPos.origin().offset(x, y, z);
                    for (OverlayDataProvider dataProvider : dataProviders) {
                        OverlayData data = dataProvider.compute(world, pos, new Vec3i(x, y, z));
                        if (!data.valid()) continue;
                        overlayData.add(data);
                    }
                }
            }
        }
        BufferBuilder builder = renderer.beforeBuild(tesselator);
        int overlayBrightness = (Integer)Config.OVERLAY_BRIGHTNESS.getValue();
        int lightmap = LightTexture.pack((int)overlayBrightness, (int)overlayBrightness);
        for (OverlayData data : overlayData) {
            renderer.build(world, data.pos(), data, builder, lightmap);
        }
        BufferHolder buffer = cachedBuffers.get(chunkPos);
        if (buffer == null) {
            buffer = new BufferHolder();
        }
        if (!overlayData.isEmpty()) {
            buffer.upload(builder.build());
        }
        return buffer;
    }

    public static void computeCache(Minecraft client) {
        if (client.player == null) {
            return;
        }
        SMACH.updateCompute(client);
        if (!SMACH.isEnabled()) {
            return;
        }
        List<OverlayDataProvider> dataProviders = DataProviders.getActiveProviders();
        OverlayRenderer renderer = Renderers.getRenderer();
        ClientLevel world = client.level;
        if (client.player == null || world == null) {
            return;
        }
        cachedBuffers.forEach((sectionPos, bufferHolder) -> {
            if (Compute.outOfRange(sectionPos)) {
                toBeRemoved.add((SectionPos)sectionPos);
            }
        });
        HashSet<SectionPos> removeFromToBeUpdated = new HashSet<SectionPos>(550);
        for (SectionPos sectionPos2 : toBeUpdated) {
            if (Compute.outOfRange(sectionPos2)) {
                toBeRemoved.add(sectionPos2);
                continue;
            }
            if (!Minecraft.getInstance().levelRenderer.isSectionCompiled(sectionPos2.origin())) continue;
            removeFromToBeUpdated.add(sectionPos2);
            cachedBuffers.compute(sectionPos2, (pos, vertexBuffer) -> {
                if (vertexBuffer != null) {
                    vertexBuffer.close();
                }
                return Compute.buildChunk(renderer, dataProviders, pos, Tesselator.getInstance(), world);
            });
        }
        for (SectionPos pos2 : removeFromToBeUpdated) {
            toBeUpdated.remove(pos2);
        }
        for (SectionPos sectionPos2 : toBeRemoved) {
            toBeUpdated.remove(sectionPos2);
            BufferHolder buf = cachedBuffers.remove(sectionPos2);
            if (buf == null) continue;
            buf.close();
        }
        toBeRemoved = new HashSet(550);
    }

    public static void render(@Nullable Frustum frustum, PoseStack matrixStack, Matrix4f projectionMatrix) {
        if (!SMACH.isEnabled()) {
            return;
        }
        if (frustum == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel world = minecraft.level;
        if (world == null) {
            return;
        }
        OverlayRenderer renderer = Renderers.getRenderer();
        renderer.beforeRendering();
        GameRenderer gameRenderer = minecraft.gameRenderer;
        Camera camera = gameRenderer.getMainCamera();
        playerPos = new ChunkPos(camera.getBlockPosition());
        matrixStack.pushPose();
        IrisCompat.fixIrisShaders(matrixStack, camera, gameRenderer, minecraft);
        matrixStack.last().pose().rotate((Quaternionfc)camera.rotation().conjugate(new Quaternionf()));
        Vec3 camPos = camera.getPosition();
        ShaderInstance shader = RenderSystem.getShader();
        float renderDistance = Minecraft.getInstance().gameRenderer.getRenderDistance() * 16.0f * 4012.0f;
        float fogStart = renderDistance - Mth.clamp((float)(renderDistance / 10.0f), (float)4.0f, (float)64.0f);
        float oldFogStart = RenderSystem.getShaderFogStart();
        float oldFogEnd = RenderSystem.getShaderFogEnd();
        FogShape oldFogShape = RenderSystem.getShaderFogShape();
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)renderDistance);
        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
        matrixStack.pushPose();
        for (int x = -computationDistance + 1; x < computationDistance; ++x) {
            for (int z = -computationDistance + 1; z < computationDistance; ++z) {
                ChunkPos chunkPos = new ChunkPos(Compute.playerPos.x + x, Compute.playerPos.z + z);
                for (int i = 0; i < world.getSectionsCount(); ++i) {
                    SectionPos chunkSection = SectionPos.of((ChunkPos)chunkPos, (int)(world.getMinSection() + i));
                    if (cachedBuffers.containsKey(chunkSection)) {
                        BufferHolder cachedBuffer = cachedBuffers.get(chunkSection);
                        if (!cachedBuffer.isValid() || !frustum.isVisible(AABB.encapsulatingFullBlocks((BlockPos)chunkSection.origin().offset(-1, -1, -1), (BlockPos)chunkSection.origin().offset(16, 16, 16)))) continue;
                        Vec3 origin = new Vec3((double)chunkSection.origin().getX(), (double)chunkSection.origin().getY(), (double)chunkSection.origin().getZ());
                        Vec3 dPos = origin.subtract(camPos);
                        cachedBuffer.draw(matrixStack.last().copy().pose().translate((float)dPos.x(), (float)dPos.y(), (float)dPos.z()), projectionMatrix, shader);
                        continue;
                    }
                    toBeUpdated.add(chunkSection);
                }
            }
        }
        matrixStack.popPose();
        RenderSystem.setShaderFogStart((float)oldFogStart);
        RenderSystem.setShaderFogEnd((float)oldFogEnd);
        RenderSystem.setShaderFogShape((FogShape)oldFogShape);
        matrixStack.popPose();
        renderer.afterRendering();
    }

    private Compute() {
    }
}

