/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.event;

import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.ShaderInstance;
import org.joml.Matrix4f;

public class BufferHolder {
    private final List<VertexBuffer> vertexBuffers = new ArrayList<VertexBuffer>();

    BufferHolder() {
    }

    boolean isValid() {
        return !this.vertexBuffers.isEmpty();
    }

    void close() {
        for (VertexBuffer buffer : this.vertexBuffers) {
            buffer.close();
        }
        this.vertexBuffers.clear();
    }

    void upload(MeshData buffer) {
        if (buffer == null) {
            return;
        }
        VertexBuffer vertexBuffer = new VertexBuffer(VertexBuffer.Usage.DYNAMIC);
        vertexBuffer.bind();
        vertexBuffer.upload(buffer);
        VertexBuffer.unbind();
        this.vertexBuffers.add(vertexBuffer);
    }

    void draw(Matrix4f positionMatrix, Matrix4f projectionMatrix, ShaderInstance shader) {
        for (VertexBuffer vertexBuffer : this.vertexBuffers) {
            vertexBuffer.bind();
            vertexBuffer.drawWithShader(positionMatrix, projectionMatrix, shader);
            VertexBuffer.unbind();
        }
    }
}

