/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.dataproviders;

import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.api.OverlayData;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;

public class BaseDataProvider
implements OverlayDataProvider {
    @Override
    public OverlayData compute(ClientLevel level, BlockPos pos, Vec3i rPos) {
        BlockPos posUp = pos.above();
        BlockState blockState = level.getBlockState(pos);
        if (LightyHelper.isBlocked(blockState, pos, level)) {
            return OverlayData.invalid();
        }
        int blockLightLevel = level.getBrightness(LightLayer.BLOCK, posUp);
        int skyLightLevel = level.getBrightness(LightLayer.SKY, posUp);
        if (LightyHelper.isSafe(blockLightLevel) && !((Boolean)Config.SHOW_SAFE.getValue()).booleanValue()) {
            return OverlayData.invalid();
        }
        int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
        float offset = LightyHelper.getOffset(blockState, pos, level);
        if (offset == -1.0f) {
            return OverlayData.invalid();
        }
        return new OverlayData(true, color, skyLightLevel, blockLightLevel, pos, rPos, offset);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"lighty", (String)"data_provider_base");
    }

    public static void init() {
        BaseDataProvider dp = new BaseDataProvider();
        ModeManager.registerDataProvider(dp.getResourceLocation(), dp);
    }
}

