/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.schmarrn.lighty.UtilDefinition;
import dev.schmarrn.lighty.mixin.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class IrisCompat {
    private static Matrix4f shaderFix(PoseStack stack, Camera camera, GameRenderer gameRenderer, Minecraft minecraft, LocalPlayer player) {
        float tickDelta = camera.getPartialTickTime();
        GameRendererAccessor gr = (GameRendererAccessor)gameRenderer;
        gr.callBobHurt(stack, tickDelta);
        if (((Boolean)minecraft.options.bobView().get()).booleanValue()) {
            gr.callBobView(stack, tickDelta);
        }
        Matrix4f instance = stack.last().pose();
        float f = minecraft.getTimer().getGameTimeDeltaPartialTick(false);
        float h = ((Double)minecraft.options.screenEffectScale().get()).floatValue();
        float i = Mth.lerp((float)f, (float)player.oSpinningEffectIntensity, (float)player.spinningEffectIntensity) * h * h;
        if (i > 0.0f) {
            int j = player.hasEffect(MobEffects.CONFUSION) ? 7 : 20;
            float k = 5.0f / (i * i + 5.0f) - i * 0.04f;
            k *= k;
            Vector3f vector3f = new Vector3f(0.0f, Mth.SQRT_OF_TWO / 2.0f, Mth.SQRT_OF_TWO / 2.0f);
            float l = ((float)gr.getConfusionAnimationTick() + f) * (float)j * ((float)Math.PI / 180);
            instance.rotate(l, (Vector3fc)vector3f);
            instance.scale(1.0f / k, 1.0f, 1.0f);
            instance.rotate(-l, (Vector3fc)vector3f);
        }
        return instance;
    }

    public static void fixIrisShaders(PoseStack stack, Camera camera, GameRenderer gr, Minecraft minecraft) {
        if (UtilDefinition.INSTANCE.shadersEnabled() && minecraft.player != null) {
            stack.last().pose().set((Matrix4fc)IrisCompat.shaderFix(stack, camera, gr, minecraft, minecraft.player));
        }
    }
}

