/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.api;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.config.Config;
import java.util.HashSet;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LightyHelper {
    static HashSet<ResourceLocation> invalidBlocks = new HashSet();

    private static boolean isRedstone(Block block) {
        return block instanceof RedStoneWireBlock || block instanceof ButtonBlock || block instanceof PressurePlateBlock || block instanceof LeverBlock;
    }

    private static boolean protectedIsValidSpawnCheck(BlockState block, BlockPos pos, ClientLevel world) {
        if (block.getBlock() instanceof MagmaBlock) {
            return true;
        }
        try {
            return block.isValidSpawn((BlockGetter)world, pos, null);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block.getBlock());
            if (!invalidBlocks.contains(rl)) {
                invalidBlocks.add(rl);
                Lighty.LOGGER.error(e.getMessage());
                Lighty.LOGGER.error("Cannot check `isValidSpawn` on Block {} because it uses entity checks. The overlay might not be accurate for that block.", (Object)rl);
            }
            return true;
        }
    }

    private static boolean specialCases(Block block) {
        return block instanceof CarpetBlock;
    }

    public static float getOffset(BlockState blockState, BlockPos pos, ClientLevel world) {
        BlockState blockStateUp = world.getBlockState(pos.above());
        Block blockUp = blockStateUp.getBlock();
        if (blockUp instanceof SnowLayerBlock) {
            int layer = (Integer)blockStateUp.getValue((Property)SnowLayerBlock.LAYERS);
            if (layer != 1) {
                return -1.0f;
            }
            return 0.125f * (float)layer;
        }
        return 0.0f;
    }

    public static boolean isBlocked(BlockState block, BlockPos pos, ClientLevel world) {
        BlockPos posUp = pos.above();
        BlockState blockStateUp = world.getBlockState(posUp);
        return blockStateUp.isCollisionShapeFullBlock((BlockGetter)world, posUp) || !block.isFaceSturdy((BlockGetter)world, pos, Direction.UP) || LightyHelper.isRedstone(blockStateUp.getBlock()) || LightyHelper.specialCases(blockStateUp.getBlock()) || !LightyHelper.protectedIsValidSpawnCheck(block, pos, world) || !blockStateUp.getFluidState().isEmpty() || !blockStateUp.getBlock().isPossibleToRespawnInThis(blockStateUp) || blockStateUp.is(BlockTags.PREVENT_MOB_SPAWNING_INSIDE);
    }

    public static boolean isSafe(int blockLightLevel) {
        return blockLightLevel > (Integer)Config.BLOCK_THRESHOLD.getValue();
    }
}

