/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.api.OverlayDataProvider;
import dev.schmarrn.lighty.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class DataProviders {
    private static final HashMap<ResourceLocation, OverlayDataProvider> DATA_PROVIDERS = new HashMap();
    private static final List<OverlayDataProvider> ACTIVE_PROVIDERS = new ArrayList<OverlayDataProvider>();

    public static void put(ResourceLocation rl, OverlayDataProvider dataProvider) {
        DATA_PROVIDERS.put(rl, dataProvider);
    }

    private static void updateConfig() {
        ArrayList activeRls = new ArrayList();
        DATA_PROVIDERS.forEach((key, value) -> {
            if (ACTIVE_PROVIDERS.contains(value)) {
                activeRls.add(key);
            }
        });
        Config.ACTIVE_DATA_PROVIDERS.setValue(activeRls);
    }

    public static void activate(ResourceLocation rl) {
        if (DATA_PROVIDERS.containsKey(rl)) {
            ACTIVE_PROVIDERS.add(DATA_PROVIDERS.get(rl));
        } else {
            Lighty.LOGGER.error("There is no OverlayDataProvider registered for {}! Not changing active OverlayDataProviders.", (Object)rl);
        }
        DataProviders.updateConfig();
    }

    public static void deactivate(ResourceLocation rl) {
        if (DATA_PROVIDERS.containsKey(rl)) {
            ACTIVE_PROVIDERS.remove(DATA_PROVIDERS.get(rl));
        } else {
            Lighty.LOGGER.error("There is no OverlayDataProvider registered for {}! Cannot remove {}.", (Object)rl, (Object)rl);
        }
        DataProviders.updateConfig();
    }

    public static void setLastActiveProviders() {
        for (ResourceLocation rl : (List)Config.ACTIVE_DATA_PROVIDERS.getValue()) {
            DataProviders.activate(rl);
        }
    }

    public static List<OverlayDataProvider> getActiveProviders() {
        return ACTIVE_PROVIDERS;
    }
}

