/*
 * Decompiled with CFR 0.152.
 */
package dev.ninjdai.letsdocompat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.ninjdai.letsdocompat.Compat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public final class RecipeJsonUtil {
    public static final Map<String, List<Tuple<String, RecipeConvertor>>> RECIPE_CONVERSION_MAP = new HashMap<String, List<Tuple<String, RecipeConvertor>>>();
    public static final RecipeConvertor generateFDCookingPotFromLDCookingPot = ldRecipe -> {
        JsonObject FDCookingPotRecipe = new JsonObject();
        FDCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farmersdelight:cooking"));
        FDCookingPotRecipe.add("recipe_book_tab", (JsonElement)new JsonPrimitive("meals"));
        FDCookingPotRecipe.add("ingredients", (JsonElement)ldRecipe.getAsJsonArray("ingredients"));
        if (ldRecipe.has("container") && ldRecipe.getAsJsonPrimitive("requireContainer").getAsBoolean()) {
            FDCookingPotRecipe.add("container", ldRecipe.get("container"));
        }
        FDCookingPotRecipe.add("result", ldRecipe.get("result"));
        return FDCookingPotRecipe;
    };
    @Nullable
    public static final RecipeConvertor generateLDCookingPotFromFDCookingPot = fdRecipe -> {
        JsonObject letsDoCookingPotRecipe = new JsonObject();
        letsDoCookingPotRecipe.add("type", (JsonElement)new JsonPrimitive("farm_and_charm:pot_cooking"));
        letsDoCookingPotRecipe.add("ingredients", (JsonElement)fdRecipe.getAsJsonArray("ingredients"));
        if (fdRecipe.has("container")) {
            letsDoCookingPotRecipe.add("requireContainer", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            letsDoCookingPotRecipe.add("container", fdRecipe.get("container"));
        } else {
            ResourceLocation resultLocation = ResourceLocation.parse((String)fdRecipe.getAsJsonObject("result").get("id").getAsString());
            if (BuiltInRegistries.ITEM.containsKey(resultLocation)) {
                Item i = (Item)BuiltInRegistries.ITEM.get(resultLocation);
                if (!i.hasCraftingRemainingItem()) return null;
                letsDoCookingPotRecipe.add("requireContainer", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                JsonObject container = new JsonObject();
                container.add("count", (JsonElement)new JsonPrimitive((Number)1));
                container.add("id", (JsonElement)new JsonPrimitive(i.getCraftingRemainingItem().toString()));
                letsDoCookingPotRecipe.add("container", (JsonElement)container);
            } else {
                Compat.LOGGER.info("FD Pot recipe for {} missing container", (Object)fdRecipe.get("result"));
                return null;
            }
        }
        letsDoCookingPotRecipe.add("result", fdRecipe.get("result"));
        letsDoCookingPotRecipe.add("requiresLearning", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        return letsDoCookingPotRecipe;
    };
    public static final RecipeConvertor generateCreateMixerFromFCBowl = jsonRecipe -> {
        JsonObject createMixerRecipe = new JsonObject();
        createMixerRecipe.add("type", (JsonElement)new JsonPrimitive("create:mixing"));
        createMixerRecipe.add("ingredients", (JsonElement)jsonRecipe.getAsJsonArray("ingredients"));
        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMixerRecipe.add("results", (JsonElement)resultsArray);
        return createMixerRecipe;
    };
    public static final RecipeConvertor generateCreateMillingFromFDMincer = jsonRecipe -> {
        JsonObject createMillingRecipe = new JsonObject();
        createMillingRecipe.add("type", (JsonElement)new JsonPrimitive("create:milling"));
        createMillingRecipe.add("processingTime", (JsonElement)new JsonPrimitive((Number)90));
        JsonArray ingredientsArray = new JsonArray();
        ingredientsArray.add(jsonRecipe.get("ingredient"));
        createMillingRecipe.add("ingredients", (JsonElement)ingredientsArray);
        JsonArray resultsArray = new JsonArray();
        resultsArray.add(jsonRecipe.get("result"));
        createMillingRecipe.add("results", (JsonElement)resultsArray);
        return createMillingRecipe;
    };

    static {
        RECIPE_CONVERSION_MAP.put("farm_and_charm:pot_cooking", List.of(new Tuple((Object)"farmersdelight", (Object)generateFDCookingPotFromLDCookingPot)));
        RECIPE_CONVERSION_MAP.put("farmersdelight:cooking", List.of(new Tuple((Object)"farm_and_charm", (Object)generateLDCookingPotFromFDCookingPot)));
        RECIPE_CONVERSION_MAP.put("farm_and_charm:crafting_bowl", List.of(new Tuple((Object)"create", (Object)generateCreateMixerFromFCBowl)));
    }

    public static interface RecipeConvertor {
        public JsonObject generate(JsonObject var1);
    }
}

