/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;

public class WineSettings {
    private final Item.Properties properties;
    private final int baseDuration;

    public WineSettings(Holder<MobEffect> effect, int duration, int strength) {
        this.baseDuration = duration;
        this.properties = new Item.Properties().food(this.createWineFoodComponent(effect, duration, strength));
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public int getBaseDuration() {
        return this.baseDuration;
    }

    private FoodProperties createWineFoodComponent(Holder<MobEffect> effect, int duration, int strength) {
        FoodProperties.Builder builder = new FoodProperties.Builder().alwaysEdible();
        if (effect != null) {
            builder.effect(new MobEffectInstance(effect, duration, strength), 1.0f);
        }
        return builder.build();
    }
}

