/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.mixin;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.npc.WanderingTraderSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.ServerLevelData;
import net.satisfy.vinery.core.entity.TraderMuleEntity;
import net.satisfy.vinery.core.registry.EntityTypeRegistry;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WanderingTraderSpawner.class})
public abstract class WanderingTraderManagerMixin
implements CustomSpawner {
    @Shadow
    @Final
    private ServerLevelData serverLevelData;

    @Shadow
    @Nullable
    protected abstract BlockPos findSpawnPositionNear(LevelReader var1, BlockPos var2, int var3);

    @Shadow
    protected abstract boolean hasEnoughSpace(BlockGetter var1, BlockPos var2);

    @Inject(method={"spawn(Lnet/minecraft/server/level/ServerLevel;)Z"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/entity/EntityType;spawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/MobSpawnType;)Lnet/minecraft/world/entity/Entity;")}, cancellable=true)
    private void trySpawn(ServerLevel world, CallbackInfoReturnable<Boolean> cir) {
        ServerPlayer playerEntity;
        if (world.random.nextDouble() < PlatformHelper.getTraderSpawnChance() && (playerEntity = world.getRandomPlayer()) != null) {
            WanderingTrader wanderingTraderEntity;
            EntityType wanderingWinemakerType;
            Holder biome;
            BlockPos blockPos = playerEntity.blockPosition();
            PoiManager pointOfInterestStorage = world.getPoiManager();
            Optional optional = pointOfInterestStorage.find(type -> type.is(PoiTypes.MEETING), pos -> true, blockPos, 48, PoiManager.Occupancy.ANY);
            BlockPos blockPos2 = optional.orElse(blockPos);
            BlockPos blockPos3 = this.findSpawnPositionNear((LevelReader)world, blockPos2, 48);
            if (blockPos3 != null && this.hasEnoughSpace((BlockGetter)world, blockPos3) && (biome = world.getBiome(blockPos3)) != null && !biome.is(Biomes.THE_VOID) && (wanderingWinemakerType = (EntityType)EntityTypeRegistry.WANDERING_WINEMAKER.get()) != null && (wanderingTraderEntity = (WanderingTrader)wanderingWinemakerType.spawn(world, blockPos3, MobSpawnType.EVENT)) != null) {
                if (PlatformHelper.shouldSpawnWithMules()) {
                    for (int j = 0; j < 2; ++j) {
                        TraderMuleEntity traderMuleEntity;
                        EntityType muleType;
                        BlockPos blockPos4 = this.findSpawnPositionNear((LevelReader)world, wanderingTraderEntity.blockPosition(), 4);
                        if (blockPos4 == null || (muleType = (EntityType)EntityTypeRegistry.MULE.get()) == null || (traderMuleEntity = (TraderMuleEntity)muleType.spawn(world, blockPos4, MobSpawnType.EVENT)) == null) continue;
                        traderMuleEntity.setLeashedTo((Entity)wanderingTraderEntity, true);
                    }
                }
                if (this.serverLevelData != null) {
                    this.serverLevelData.setWanderingTraderId(wanderingTraderEntity.getUUID());
                    wanderingTraderEntity.setDespawnDelay(PlatformHelper.getTraderSpawnDelay());
                    wanderingTraderEntity.setWanderTarget(blockPos2);
                    wanderingTraderEntity.restrictTo(blockPos2, 16);
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

