/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block.state.properties;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public class GrapeProperty
extends Property<GrapeType> {
    private final Set<GrapeType> values = GrapeTypeRegistry.GRAPE_TYPE_TYPES;

    protected GrapeProperty(String name) {
        super(name, GrapeType.class);
    }

    public static GrapeProperty create(String name) {
        return new GrapeProperty(name);
    }

    @NotNull
    public Collection<GrapeType> getPossibleValues() {
        return this.values;
    }

    @NotNull
    public String getName(GrapeType grapeType) {
        return grapeType.getSerializedName();
    }

    @NotNull
    public Optional<GrapeType> getValue(String string) {
        for (GrapeType grapeType : this.values) {
            if (!string.equals(grapeType.getSerializedName())) continue;
            return Optional.of(grapeType);
        }
        return Optional.empty();
    }
}

