/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.items;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class DrinkBlockItem
extends BlockItem {
    public DrinkBlockItem(Block block, Item.Properties settings) {
        super(block, settings.stacksTo(16));
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        FoodProperties foodProperties;
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (potionContents.hasEffects()) {
            potionContents.forEachEffect(arg_0 -> ((LivingEntity)user).addEffect(arg_0));
        }
        if ((foodProperties = (FoodProperties)stack.get(DataComponents.FOOD)) != null) {
            foodProperties.effects().forEach(possibleEffect -> user.addEffect(possibleEffect.effect()));
        }
        return super.finishUsingItem(stack, world, user);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag context) {
        FoodProperties food;
        LinkedHashMap<ResourceLocation, MobEffectInstance> combined = new LinkedHashMap<ResourceLocation, MobEffectInstance>();
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (potionContents.hasEffects()) {
            potionContents.forEachEffect(inst -> {
                ResourceLocation id = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)inst.getEffect().value()));
                MobEffectInstance prev = (MobEffectInstance)combined.get(id);
                if (prev == null) {
                    combined.put(id, (MobEffectInstance)inst);
                } else {
                    int amp = Math.max(prev.getAmplifier(), inst.getAmplifier());
                    int dur = Math.max(prev.getDuration(), inst.getDuration());
                    boolean amb = prev.isAmbient() || inst.isAmbient();
                    boolean vis = prev.isVisible() || inst.isVisible();
                    boolean icon = prev.showIcon() || inst.showIcon();
                    combined.put(id, new MobEffectInstance(prev.getEffect(), dur, amp, amb, vis, icon));
                }
            });
        }
        if ((food = (FoodProperties)stack.get(DataComponents.FOOD)) != null) {
            for (FoodProperties.PossibleEffect e : food.effects()) {
                MobEffectInstance inst2 = e.effect();
                ResourceLocation id = BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)inst2.getEffect().value()));
                MobEffectInstance prev = (MobEffectInstance)combined.get(id);
                if (prev == null) {
                    combined.put(id, inst2);
                    continue;
                }
                int amp = Math.max(prev.getAmplifier(), inst2.getAmplifier());
                int dur = Math.max(prev.getDuration(), inst2.getDuration());
                boolean amb = prev.isAmbient() || inst2.isAmbient();
                boolean vis = prev.isVisible() || inst2.isVisible();
                boolean icon = prev.showIcon() || inst2.showIcon();
                combined.put(id, new MobEffectInstance(prev.getEffect(), dur, amp, amb, vis, icon));
            }
        }
        if (combined.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (MobEffectInstance inst3 : combined.values()) {
                MutableComponent effectName = Component.translatable((String)inst3.getDescriptionId());
                if (inst3.getDuration() > 20) {
                    effectName = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{effectName, MobEffectUtil.formatDuration((MobEffectInstance)inst3, (float)1.0f, (float)20.0f)});
                }
                tooltip.add((Component)effectName.withStyle(((MobEffect)inst3.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
        ArrayList attributeModifiers = Lists.newArrayList();
        if (stack.has(DataComponents.ATTRIBUTE_MODIFIERS)) {
            ItemAttributeModifiers itemAttributeModifiers = (ItemAttributeModifiers)stack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY);
            itemAttributeModifiers.modifiers().forEach(entry -> {
                Attribute attribute = (Attribute)entry.attribute().value();
                double amount = entry.modifier().amount();
                AttributeModifier modifier = new AttributeModifier(entry.modifier().id(), amount, entry.modifier().operation());
                attributeModifiers.add(new Pair((Object)attribute, (Object)modifier));
            });
        }
        if (!attributeModifiers.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attributeModifiers) {
                double displayAmount;
                AttributeModifier modifier = (AttributeModifier)pair.getSecond();
                double amount = modifier.amount();
                double d = displayAmount = modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || modifier.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? amount * 100.0 : amount;
                if (amount > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(displayAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-displayAmount), Component.translatable((String)((Attribute)pair.getFirst()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.herbalbrews.canbeplaced").withStyle(style -> style.withColor(TextColor.fromRgb((int)13467442)).withItalic(Boolean.valueOf(true))));
    }
}

