/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.compat.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;
import net.satisfy.herbalbrews.client.gui.handler.CauldronGuiHandler;
import net.satisfy.herbalbrews.client.gui.handler.TeaKettleGuiHandler;
import net.satisfy.herbalbrews.core.compat.jei.category.CauldronCategory;
import net.satisfy.herbalbrews.core.compat.jei.category.TeaKettleCategory;
import net.satisfy.herbalbrews.core.recipe.CauldronRecipe;
import net.satisfy.herbalbrews.core.recipe.TeaKettleRecipe;
import net.satisfy.herbalbrews.core.registry.MenuTypeRegistry;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.core.registry.RecipeTypeRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class HerbalBrewsJEIPlugin
implements IModPlugin {
    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new TeaKettleCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List teaKettleRecipeHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get());
        ArrayList teaKettleRecipes = new ArrayList();
        teaKettleRecipeHolders.iterator().forEachRemaining(recipeHolder -> teaKettleRecipes.add((TeaKettleRecipe)recipeHolder.value()));
        registration.addRecipes(TeaKettleCategory.TEA_KETTLE_TYPE, teaKettleRecipes);
        List cauldronRecipeHolders = rm.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)RecipeTypeRegistry.CAULDRON_RECIPE_TYPE.get());
        ArrayList cauldronRecipes = new ArrayList();
        cauldronRecipeHolders.iterator().forEachRemaining(recipeHolder -> cauldronRecipes.add((CauldronRecipe)recipeHolder.value()));
        registration.addRecipes(CauldronCategory.CAULDRON_TYPE, cauldronRecipes);
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return HerbalBrewsIdentifier.identifier("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(TeaKettleGuiHandler.class, (MenuType)MenuTypeRegistry.TEA_KETTLE_SCREEN_HANDLER.get(), TeaKettleCategory.TEA_KETTLE_TYPE, 1, 6, 7, 36);
        registration.addRecipeTransferHandler(CauldronGuiHandler.class, (MenuType)MenuTypeRegistry.CAULDRON_SCREEN_HANDLER.get(), CauldronCategory.CAULDRON_TYPE, 1, 3, 5, 36);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Block)ObjectRegistry.CAULDRON.get()).asItem().getDefaultInstance(), new RecipeType[]{CauldronCategory.CAULDRON_TYPE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.TEA_KETTLE.get()).asItem().getDefaultInstance(), new RecipeType[]{TeaKettleCategory.TEA_KETTLE_TYPE});
        registration.addRecipeCatalyst(((Block)ObjectRegistry.COPPER_TEA_KETTLE.get()).asItem().getDefaultInstance(), new RecipeType[]{TeaKettleCategory.TEA_KETTLE_TYPE});
    }
}

