/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.herbalbrews.core.blocks.TeaLeafBlock;
import net.satisfy.herbalbrews.core.registry.EntityTypeRegistry;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import net.satisfy.herbalbrews.platform.PlatformHelper;

public class TeaLeafBlockEntity
extends BlockEntity
implements BlockEntityTicker<TeaLeafBlockEntity> {
    private int timer = 0;

    public TeaLeafBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.TEA_LEAF_BLOCK_ENTITY.get(), pos, state);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.timer = compoundTag.getInt("Timer");
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("Timer", this.timer);
    }

    private Block getEndBlock(Block startBlock) {
        if (startBlock == ObjectRegistry.GREEN_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.DRIED_OUT_GREEN_TEA_LEAF_BLOCK.get();
        }
        if (startBlock == ObjectRegistry.MIXED_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.OOLONG_TEA_LEAF_BLOCK.get();
        }
        if (startBlock == ObjectRegistry.DRIED_GREEN_TEA_LEAF_BLOCK.get()) {
            return (Block)ObjectRegistry.BLACK_TEA_LEAF_BLOCK.get();
        }
        return Blocks.AIR;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, TeaLeafBlockEntity blockEntity) {
        if (level == null || level.isClientSide) {
            return;
        }
        int dryingDuration = PlatformHelper.getDryingDuration();
        ++this.timer;
        if (this.timer >= dryingDuration) {
            BlockState state = level.getBlockState(blockPos);
            int dryingStage = (Integer)state.getValue((Property)TeaLeafBlock.DRYING);
            if (dryingStage < 4) {
                level.levelEvent(2001, blockPos, Block.getId((BlockState)state));
                level.playSound(null, blockPos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlockAndUpdate(blockPos, (BlockState)state.setValue((Property)TeaLeafBlock.DRYING, (Comparable)Integer.valueOf(dryingStage + 1)));
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((BlockState)state));
                this.timer = 0;
            } else {
                Block endBlock = this.getEndBlock(state.getBlock());
                if (endBlock != Blocks.AIR) {
                    level.setBlockAndUpdate(blockPos, endBlock.defaultBlockState());
                }
            }
        }
    }
}

