/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.herbalbrews.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CoffeeCropBlock
extends CropBlock {
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public CoffeeCropBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    protected ItemLike getBaseSeedId() {
        return (ItemLike)ObjectRegistry.COFFEE_BEANS.get();
    }

    public int getMaxAge() {
        return 3;
    }

    @NotNull
    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        boolean bl;
        int i = (Integer)blockState.getValue((Property)AGE);
        boolean bl2 = bl = i == 3;
        if (!bl && player.getItemInHand(interactionHand).is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (i > 1) {
            int tomatoCount = level.random.nextInt(2) + (bl ? 1 : 0);
            CoffeeCropBlock.popResource((Level)level, (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)ObjectRegistry.COFFEE_BEANS.get(), tomatoCount));
            level.playSound(null, blockPos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(itemStack, blockState, level, blockPos, player, interactionHand, blockHitResult);
    }
}

