/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.farm_and_charm.core.entity.AbstractTowableEntity;

public final class CartWheel {
    private float rotation;
    private float rotationIncrement;
    private final float offsetX;
    private final float offsetZ;
    private final float circumference;
    private double posX;
    private double posZ;
    private double prevPosX;
    private double prevPosZ;
    private final AbstractTowableEntity cart;

    public CartWheel(AbstractTowableEntity cartIn, float offsetXIn, float offsetZIn, float circumferenceIn) {
        this.cart = cartIn;
        this.offsetX = offsetXIn;
        this.offsetZ = offsetZIn;
        this.circumference = circumferenceIn;
        this.posX = this.prevPosX = cartIn.getX();
        this.posZ = this.prevPosZ = cartIn.getZ();
    }

    public CartWheel(AbstractTowableEntity cartIn, float offsetX) {
        this(cartIn, offsetX, 0.0f, 3.9269907f);
    }

    public void tick() {
        this.rotation += this.rotationIncrement;
        this.prevPosX = this.posX;
        this.prevPosZ = this.posZ;
        float yaw = (float)Math.toRadians(this.cart.getYRot());
        float nx = -Mth.sin((float)yaw);
        float nz = Mth.cos((float)yaw);
        this.posX = this.cart.getX() + (double)(nx * this.offsetZ) - (double)(nz * this.offsetX);
        this.posZ = this.cart.getZ() + (double)(nz * this.offsetZ) + (double)(nx * this.offsetX);
        double dx = this.posX - this.prevPosX;
        double dz = this.posZ - this.prevPosZ;
        float distanceTravelled = (float)Math.sqrt(dx * dx + dz * dz);
        double dxNormalized = distanceTravelled > 0.0f ? dx / (double)distanceTravelled : 0.0;
        double dzNormalized = distanceTravelled > 0.0f ? dz / (double)distanceTravelled : 0.0;
        float travelledForward = Mth.sign((double)(dxNormalized * (double)nx + dzNormalized * (double)nz));
        if ((double)distanceTravelled > 0.05) {
            BlockPos blockpos = new BlockPos(Mth.floor((double)this.posX), Mth.floor((double)(this.cart.getY() - (double)0.2f)), Mth.floor((double)this.posZ));
            BlockState blockstate = this.cart.level().getBlockState(blockpos);
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                int particleCount = 8;
                float sideYaw = (float)Math.toRadians(this.cart.getYRot());
                double sideX = -Mth.cos((float)sideYaw);
                double sideZ = -Mth.sin((float)sideYaw);
                double upwardVelocity = Math.min((double)distanceTravelled * 0.1, 0.15);
                for (int i = 0; i < particleCount; ++i) {
                    double centerShiftFactor = 0.3;
                    double px = this.posX - sideX * (double)this.offsetX * centerShiftFactor + (this.cart.getRandom().nextDouble() - 0.5) * 0.02;
                    double py = blockpos.getY() + 1;
                    double pz = this.posZ - sideZ * (double)this.offsetX * centerShiftFactor + (this.cart.getRandom().nextDouble() - 0.5) * 0.02;
                    this.cart.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), px, py, pz, dx * 0.05, upwardVelocity, dz * 0.05);
                }
            }
        }
        this.rotationIncrement = travelledForward * distanceTravelled * this.circumference * 0.2f;
    }

    public float getRotation() {
        return this.rotation;
    }
}

