/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.satisfy.farm_and_charm.FarmAndCharm;
import net.satisfy.farm_and_charm.core.effect.ChickenEffect;
import net.satisfy.farm_and_charm.core.effect.DogFoodEffect;
import net.satisfy.farm_and_charm.core.effect.FarmersBlessingEffect;
import net.satisfy.farm_and_charm.core.effect.FeastEffect;
import net.satisfy.farm_and_charm.core.effect.GrandmasBlessingEffect;
import net.satisfy.farm_and_charm.core.effect.HorseFodderEffect;
import net.satisfy.farm_and_charm.core.effect.RestedEffect;
import net.satisfy.farm_and_charm.core.effect.SatiationEffect;
import net.satisfy.farm_and_charm.core.effect.SustenanceEffect;
import net.satisfy.farm_and_charm.core.effect.SweetsEffect;

public class MobEffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.MOB_EFFECT);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> SWEETS = MobEffectRegistry.registerEffect("sweets", SweetsEffect::new);
    public static final RegistrySupplier<MobEffect> HORSE_FODDER = MobEffectRegistry.registerEffect("horse_fodder", HorseFodderEffect::new);
    public static final RegistrySupplier<MobEffect> DOG_FOOD = MobEffectRegistry.registerEffect("dog_food", DogFoodEffect::new);
    public static final RegistrySupplier<MobEffect> CLUCK = MobEffectRegistry.registerEffect("cluck", ChickenEffect::new);
    public static final RegistrySupplier<MobEffect> GRANDMAS_BLESSING = MobEffectRegistry.registerEffect("grandmas_blessing", GrandmasBlessingEffect::new);
    public static final RegistrySupplier<MobEffect> RESTED = MobEffectRegistry.registerEffect("rested", RestedEffect::new);
    public static final RegistrySupplier<MobEffect> FARMERS_BLESSING = MobEffectRegistry.registerEffect("farmers_blessing", FarmersBlessingEffect::new);
    public static final RegistrySupplier<MobEffect> SUSTENANCE = MobEffectRegistry.registerEffect("sustenance", SustenanceEffect::new);
    public static final RegistrySupplier<MobEffect> SATIATION = MobEffectRegistry.registerEffect("satiation", SatiationEffect::new);
    public static final RegistrySupplier<MobEffect> FEAST = MobEffectRegistry.registerEffect("feast", FeastEffect::new);

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isNeoForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register(FarmAndCharm.identifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    public static Holder<MobEffect> holder(RegistrySupplier<MobEffect> supplier) {
        return (Holder)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)((MobEffect)supplier.get())).flatMap(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).getHolder(arg_0)).orElseThrow();
    }

    public static MobEffectInstance inst(RegistrySupplier<MobEffect> supplier, int duration) {
        return new MobEffectInstance(MobEffectRegistry.holder(supplier), duration);
    }
}

