/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.recipe;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class RecipeUnlockSavedData
extends SavedData {
    private final Map<UUID, Set<ResourceLocation>> playerRecipes = new HashMap<UUID, Set<ResourceLocation>>();
    public static final String DATA_NAME = "farm_and_charm_recipe_unlock_data";

    public RecipeUnlockSavedData() {
    }

    public RecipeUnlockSavedData(CompoundTag compoundTag, HolderLookup.Provider provider) {
    }

    public static RecipeUnlockSavedData fromNbt(CompoundTag tag) {
        RecipeUnlockSavedData data = new RecipeUnlockSavedData();
        CompoundTag playersTag = tag.getCompound("players");
        for (String key : playersTag.getAllKeys()) {
            ListTag list = playersTag.getList(key, 8);
            HashSet<ResourceLocation> recipes = new HashSet<ResourceLocation>();
            for (int i = 0; i < list.size(); ++i) {
                recipes.add(ResourceLocation.parse((String)list.getString(i)));
            }
            try {
                UUID uuid = UUID.fromString(key);
                data.playerRecipes.put(uuid, recipes);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag playersTag = new CompoundTag();
        for (Map.Entry<UUID, Set<ResourceLocation>> entry : this.playerRecipes.entrySet()) {
            ListTag list = new ListTag();
            for (ResourceLocation recipe : entry.getValue()) {
                list.add((Object)StringTag.valueOf((String)recipe.toString()));
            }
            playersTag.put(entry.getKey().toString(), (Tag)list);
        }
        compoundTag.put("players", (Tag)playersTag);
        return compoundTag;
    }

    public Set<ResourceLocation> getPlayerRecipes(UUID uuid) {
        return this.playerRecipes.computeIfAbsent(uuid, k -> new HashSet());
    }

    public void setPlayerRecipes(UUID uuid, Set<ResourceLocation> recipes) {
        this.playerRecipes.put(uuid, recipes);
        this.setDirty();
    }

    public static SavedData.Factory<RecipeUnlockSavedData> factory() {
        return new SavedData.Factory(RecipeUnlockSavedData::new, RecipeUnlockSavedData::new, DataFixTypes.SAVED_DATA_MAP_DATA);
    }
}

